/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.serial;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversallyPrintable;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class UniversalHolder
implements Serializable,
UniversallyPrintable {
    private static final UniversalContext NIL = new UniversalContext(""){

        @Override
        public void print(OutputPrinter out) {
        }
    };
    private final UniversalItem o;

    UniversalHolder(UniversalItem context) {
        this.o = Objects.requireNonNull(context);
    }

    @Override
    public void print(OutputPrinter out) {
        this.o.print(out);
    }

    public static class Builder
    extends OutputPrinter {
        private final Deque<UniversalContext> contexts = new ArrayDeque<UniversalContext>();

        public UniversalHolder build() {
            UniversalContext context = this.contexts.peekLast();
            if (context == null) {
                context = NIL;
            }
            return new UniversalHolder(context);
        }

        @Override
        public @Nullable OutputType getType() {
            return null;
        }

        @Override
        public void startObject(String name, OutputPrinter.ObjectOption option) {
            UniversalContext context;
            UniversalObject object = new UniversalObject(name, option);
            if (!this.contexts.isEmpty() && (context = this.contexts.peek()) != null) {
                context.items.add(object);
            }
            this.contexts.push(object);
        }

        @Override
        public void endObject() {
            if (this.contexts.size() > 1) {
                this.contexts.pop();
            }
        }

        @Override
        public void startCollection(String name, OutputPrinter.CollectionOption option) {
            UniversalContext context;
            UniversalCollection collection = new UniversalCollection(name, option);
            if (!this.contexts.isEmpty() && (context = this.contexts.peek()) != null) {
                context.items.add(collection);
            }
            this.contexts.push(collection);
        }

        @Override
        public void endCollection() {
            if (this.contexts.size() > 1) {
                this.contexts.pop();
            }
        }

        @Override
        public void field(String name, boolean value, OutputPrinter.FieldOption option) {
            this.addFieldIfContext(new UniversalBooleanField(name, value, option));
        }

        @Override
        public void field(String name, long value, OutputPrinter.FieldOption option) {
            this.addFieldIfContext(new UniversalLongField(name, value, option));
        }

        @Override
        public void field(String name, String value, OutputPrinter.FieldOption option) {
            this.addFieldIfContext(new UniversalStringField(name, value, option));
        }

        @Override
        public void field(String name, String[] values, OutputPrinter.FieldOption option) {
            this.addFieldIfContext(new UniversalStringArrayField(name, values, option));
        }

        private void addFieldIfContext(UniversalField<?> field) {
            UniversalContext context = this.contexts.peek();
            if (context != null) {
                context.items.add(field);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    public static final class UniversalBooleanField
    extends UniversalField<Boolean>
    implements Serializable,
    UniversallyPrintable {
        UniversalBooleanField(String name, Boolean value, OutputPrinter.FieldOption option) {
            super(name, value, option);
        }

        @Override
        public void print(OutputPrinter out) {
            out.field(this.name(), (Boolean)this.value(), this.option());
        }
    }

    public static final class UniversalLongField
    extends UniversalField<Long>
    implements Serializable,
    UniversallyPrintable {
        UniversalLongField(String name, Long value, OutputPrinter.FieldOption option) {
            super(name, value, option);
        }

        @Override
        public void print(OutputPrinter out) {
            out.field(this.name(), (Long)this.value(), this.option());
        }
    }

    public static final class UniversalStringArrayField
    extends UniversalField<String[]>
    implements Serializable,
    UniversallyPrintable {
        UniversalStringArrayField(String name, String[] values, OutputPrinter.FieldOption option) {
            super(name, values, option);
        }

        @Override
        public void print(OutputPrinter out) {
            out.field(this.name(), (String[])this.value(), this.option());
        }
    }

    public static final class UniversalStringField
    extends UniversalField<String>
    implements Serializable,
    UniversallyPrintable {
        UniversalStringField(String name, String value, OutputPrinter.FieldOption option) {
            super(name, value, option);
        }

        @Override
        public void print(OutputPrinter out) {
            out.field(this.name(), (String)this.value(), this.option());
        }
    }

    public static abstract class UniversalField<T extends Serializable>
    extends UniversalItem
    implements Serializable,
    UniversallyPrintable {
        private final T value;
        private final OutputPrinter.FieldOption option;

        UniversalField(String name, T value, OutputPrinter.FieldOption option) {
            super(name);
            this.value = value;
            this.option = option;
        }

        public T value() {
            return this.value;
        }

        public OutputPrinter.FieldOption option() {
            return this.option;
        }
    }

    public static class UniversalCollection
    extends UniversalContext
    implements Serializable,
    UniversallyPrintable {
        private final OutputPrinter.CollectionOption option;

        UniversalCollection(String name, OutputPrinter.CollectionOption option) {
            super(name);
            this.option = option;
        }

        public OutputPrinter.CollectionOption option() {
            return this.option;
        }

        @Override
        public void print(OutputPrinter out) {
            out.startCollection(this.name(), this.option);
            for (UniversalItem item : this.items()) {
                item.print(out);
            }
            out.endCollection();
        }
    }

    public static class UniversalObject
    extends UniversalContext
    implements Serializable,
    UniversallyPrintable {
        private final OutputPrinter.ObjectOption option;

        UniversalObject(String name, OutputPrinter.ObjectOption option) {
            super(name);
            this.option = option;
        }

        public OutputPrinter.ObjectOption option() {
            return this.option;
        }

        @Override
        public void print(OutputPrinter out) {
            out.startObject(this.name(), this.option);
            for (UniversalItem item : this.items()) {
                item.print(out);
            }
            out.endObject();
        }
    }

    public static abstract class UniversalContext
    extends UniversalItem
    implements Serializable,
    UniversallyPrintable {
        private final List<UniversalItem> items = new ArrayList<UniversalItem>();

        UniversalContext(String name) {
            super(name);
        }

        List<UniversalItem> items() {
            return this.items;
        }
    }

    public static abstract class UniversalItem
    implements Serializable,
    UniversallyPrintable {
        private final String name;

        UniversalItem(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }
}

