/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.KeyStorageException;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStorage.class);
    private static final String KEYSTORE_PATH = "config/pageseeder.jceks";
    private static final String KEYSTORE_TYPE = "jceks";
    private static final char[] KEYSTORE_PASSWORD = Double.toHexString(8.539734222673566).toCharArray();
    private static @Nullable KeyStorage singleton = null;
    private final Path location;
    private final Map<String, SecretKey> cache = new HashMap<String, SecretKey>();
    private long lastModified = 0L;

    private KeyStorage(Path location) {
        this.location = location;
    }

    public static synchronized KeyStorage getInstance() {
        KeyStorage instance = singleton;
        if (instance == null) {
            Path webInf = new File(Settings.getContextPath() + "/WEB-INF/").toPath();
            singleton = instance = new KeyStorage(webInf.resolve(KEYSTORE_PATH));
        }
        return instance;
    }

    public synchronized @Nullable SecretKey getSecretKeySilently(String alias, KeyType type) {
        try {
            return this.getSecretKey(alias, type);
        }
        catch (KeyStorageException ex) {
            LOGGER.error("Unable to retrieve secret key for alias: {}", (Object)alias, (Object)ex);
            return null;
        }
    }

    public synchronized SecretKey getSecretKey(String alias, KeyType type) throws KeyStorageException {
        SecretKey key = null;
        if (this.lastModified > 0L && this.lastModified == this.location.toFile().lastModified()) {
            key = this.cache.get(alias);
        } else {
            this.cache.clear();
        }
        if (key == null) {
            KeyStore store = KeyStorage.ensureLoaded(this.location);
            key = this.getSecretKey(store, alias, type);
            this.cache.put(alias, key);
            this.lastModified = this.location.toFile().lastModified();
        }
        return key;
    }

    synchronized void delete() throws IOException {
        if (Files.exists(this.location, new LinkOption[0])) {
            Files.delete(this.location);
        }
    }

    private SecretKey getSecretKey(KeyStore store, String alias, KeyType type) throws KeyStorageException {
        try {
            if (store.isKeyEntry(alias)) {
                Key akey = store.getKey(alias, KEYSTORE_PASSWORD);
                if (akey instanceof SecretKey) {
                    return (SecretKey)akey;
                }
                throw new KeyStorageException("Unable to retrieve secret key for alias: " + alias);
            }
            return this.generateSecretKey(store, alias, type);
        }
        catch (GeneralSecurityException ex) {
            throw new KeyStorageException("Unable to retrieve private key store", ex);
        }
    }

    private SecretKey generateSecretKey(KeyStore store, String alias, KeyType type) throws KeyStorageException {
        byte[] raw = new byte[type.lengthInBytes()];
        new SecureRandom().nextBytes(raw);
        LOGGER.debug("Generating new secret key: {} ({})", (Object)alias, (Object)type);
        try {
            SecretKeySpec key = new SecretKeySpec(raw, type.algorithm());
            store.setKeyEntry(alias, key, KEYSTORE_PASSWORD, null);
            try (OutputStream out = Files.newOutputStream(this.location, new OpenOption[0]);){
                store.store(out, KEYSTORE_PASSWORD);
            }
            return key;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new KeyStorageException("Unable to write to key store", ex);
        }
    }

    private static KeyStore ensureLoaded(Path location) throws KeyStorageException {
        if (Files.exists(location, new LinkOption[0])) {
            return KeyStorage.loadStore(location);
        }
        return KeyStorage.createStore(location);
    }

    private static KeyStore createStore(Path path) throws KeyStorageException {
        KeyStore keyStore;
        block9: {
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
            File parent = path.toFile().getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new KeyStorageException("Unable to create directory for key store: " + parent.getAbsolutePath());
            }
            OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
            try {
                store.load(null, KEYSTORE_PASSWORD);
                store.store(out, KEYSTORE_PASSWORD);
                keyStore = store;
                if (out == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw new KeyStorageException("Unable to create key store", ex);
                }
            }
            out.close();
        }
        return keyStore;
    }

    private static KeyStore loadStore(Path path) throws KeyStorageException {
        KeyStore keyStore;
        block9: {
            LOGGER.info("Loading the key store from {}", (Object)path.toAbsolutePath());
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
                store.load(in, KEYSTORE_PASSWORD);
                keyStore = store;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KeyStoreException ex) {
                    throw new KeyStorageException("Unable to instantiate key store", ex);
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw new KeyStorageException("Unable to load the key store", ex);
                }
            }
            in.close();
        }
        return keyStore;
    }

    public static enum KeyType {
        AES("AES", 16),
        BLOWFISH("Blowfish", 16),
        HMAC_SHA_256("HmacSHA256", 16);

        private final String algorithm;
        private final int lengthInBytes;

        private KeyType(String algorithm, int length) {
            this.algorithm = algorithm;
            this.lengthInBytes = length;
        }

        int lengthInBytes() {
            return this.lengthInBytes;
        }

        public String algorithm() {
            return this.algorithm;
        }
    }
}

