/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.common.UnforeseenException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class HOTPGenerator {
    private final Mac prototypeMac;
    private final CodeLength codeLength;
    public static final CodeLength DEFAULT_CODE_LENGTH = CodeLength.SIX;
    static final String HOTP_HMAC_ALGORITHM = "HmacSHA1";

    public HOTPGenerator() {
        this(CodeLength.SIX);
    }

    public HOTPGenerator(CodeLength codeLength) {
        this(codeLength, HOTP_HMAC_ALGORITHM);
    }

    HOTPGenerator(CodeLength codeLength, String algorithm) {
        try {
            this.prototypeMac = Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.codeLength = codeLength;
    }

    public int generateOneTimePassword(Key key, long counter) throws InvalidKeyException {
        Mac mac = this.getMac();
        ByteBuffer buffer = ByteBuffer.allocate(mac.getMacLength());
        buffer.putLong(0, counter);
        try {
            byte[] array = buffer.array();
            mac.init(key);
            mac.update(array, 0, 8);
            mac.doFinal(array, 0);
        }
        catch (ShortBufferException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        int offset = buffer.get(buffer.capacity() - 1) & 0xF;
        return (buffer.getInt(offset) & Integer.MAX_VALUE) % this.codeLength.modDivisor;
    }

    private Mac getMac() {
        try {
            return (Mac)this.prototypeMac.clone();
        }
        catch (CloneNotSupportedException e) {
            try {
                return Mac.getInstance(this.prototypeMac.getAlgorithm());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new UnforeseenException((Throwable)ex);
            }
        }
    }

    public String generateOneTimePasswordString(Key key, long counter) throws InvalidKeyException {
        return this.generateOneTimePasswordString(key, counter, Locale.getDefault());
    }

    public String generateOneTimePasswordString(Key key, long counter, Locale locale) throws InvalidKeyException {
        return this.codeLength.format(this.generateOneTimePassword(key, counter), locale);
    }

    String formatOneTimePassword(int oneTimePassword, Locale locale) {
        return this.codeLength.format(oneTimePassword, locale);
    }

    public int getCodeLength() {
        return this.codeLength.length;
    }

    public String getAlgorithm() {
        return this.prototypeMac.getAlgorithm();
    }

    public static enum CodeLength {
        SIX(6),
        SEVEN(7),
        EIGHT(8);

        private final int length;
        private final int modDivisor;
        private final String formatString;

        private CodeLength(int length) {
            this.length = length;
            this.modDivisor = (int)Math.pow(10.0, length);
            this.formatString = "%0" + length + "d";
        }

        public int length() {
            return this.length;
        }

        public String format(int otp, Locale locale) {
            return String.format(locale, this.formatString, otp);
        }

        public static CodeLength forLength(int length) {
            for (CodeLength codeLength : CodeLength.values()) {
                if (codeLength.length != length) continue;
                return codeLength;
            }
            throw new IllegalArgumentException("Invalid code length: " + length);
        }
    }
}

