/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.cache.SafeCacheWrapper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MembershipCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MembershipCache.class);
    private static final String CACHE_NAME = "membership-etags";
    private final SafeCacheWrapper<String, Long> etagsCache = SafeCacheWrapper.getInstance("membership-etags");

    public Long getETag(Long memberId) {
        Objects.requireNonNull(memberId, "Member id cannot be null");
        String key = memberId.toString();
        Long etag = this.etagsCache.get(key);
        if (etag == null) {
            LOGGER.debug("Creating membership etag: {}", (Object)key);
            etag = System.nanoTime();
            this.etagsCache.put(key, etag);
        } else {
            LOGGER.debug("Reading membership etag from cache: {}", (Object)key);
        }
        return etag;
    }

    public void remove(Long memberId) {
        LOGGER.debug("Removing membership etag from cache: {}", (Object)memberId);
        this.etagsCache.remove(memberId.toString());
    }

    public void removeAll() {
        LOGGER.debug("Removing all membership etags from cache");
        this.etagsCache.removeAll();
    }
}

