/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class MemberGroupDetailsRule {
    public static final String DETAILS_FOLDER = "member";

    private MemberGroupDetailsRule() {
    }

    public static @Nullable MemberDetailsConfig getMemberDetailsConfig(Group group) throws FoundationException {
        File context;
        String form = group.getDetailsForm();
        if (form == null) {
            return null;
        }
        int i = form.lastIndexOf(46);
        if (i == -1) {
            i = form.length();
        }
        String name = form.substring(0, i);
        String template = group.getOwnerDirectory();
        Template kit = new Template(template);
        File xml = TemplateFiles.find((Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)(context = new File(Settings.getContextPath())), (String)("member/" + name + ".xml"));
        if (xml != null) {
            return MemberDetailsConfig.parse(xml);
        }
        String path = "layout/Page/group-member-groupdetails-" + name + ".properties";
        File prp = TemplateFiles.find((Template)kit, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)context, (String)path);
        if (prp != null) {
            return MemberDetailsConfig.loadProperties(prp);
        }
        throw new FoundationException("Unable to find details config for group " + group.getName());
    }

    public static Set<String> listDetailsTypes(Group group) {
        File dir;
        String globalTemplate;
        File dir2;
        String ownerdir = group.getOwnerDirectory();
        if (GroupRule.isProject(group)) {
            ownerdir = group.getName();
        }
        HashSet<String> types = new HashSet<String>();
        File webapp = new File(Settings.getContextPath());
        File template = new File(webapp, "WEB-INF" + File.separator + "config" + File.separator + "template");
        TypeCollector collector = new TypeCollector(types);
        if (!Strings.isEmpty((String)ownerdir) && (dir2 = new File(template, ownerdir + File.separator + DETAILS_FOLDER)).exists()) {
            dir2.listFiles(collector);
        }
        if (!Strings.isEmpty((String)(globalTemplate = GlobalSettings.getGlobalTemplate())) && (dir = new File(template, globalTemplate + File.separator + DETAILS_FOLDER)).exists()) {
            dir.listFiles(collector);
        }
        if ((dir = new File(template, "default" + File.separator + DETAILS_FOLDER)).exists()) {
            dir.listFiles(collector);
        }
        return types;
    }

    public static MemberGroupDetails updateDetails(Database db, Transaction tr, HttpServletRequest req, Member member, Group group, MemberForGroup mfg, boolean force) throws IOException, DatabaseException {
        List<String> fields = MemberGroupDetailsRule.toFieldValues(req);
        return MemberGroupDetailsRule.updateDetails(db, tr, member, fields, group, mfg, force);
    }

    public static MemberGroupDetails updateDetails(Database db, Member member, List<String> details, Group group, MemberForGroup mfg, boolean force) throws IOException, DatabaseException {
        return MemberGroupDetailsRule.updateDetails(db, null, member, details, group, mfg, force);
    }

    public static MemberGroupDetails updateDetails(Database db, Transaction tr, Member member, List<String> details, Group group, MemberForGroup mfg, boolean force) throws IOException, DatabaseException {
        MemberGroupDetails mgd = null;
        MemberDetailsConfig config = null;
        try {
            config = MemberGroupDetailsRule.getMemberDetailsConfig(group);
        }
        catch (FoundationException ex) {
            throw new IOException(ex);
        }
        if (config != null) {
            MemberGroupDetails current = null;
            if (config.isShared()) {
                current = DatabaseQuery.getMemberGroupDetailsByMemberIdOwnerForm((Database)db, (Long)member.getId(), (String)group.getOwner(), (String)group.getDetailsForm());
            } else if (mfg != null) {
                current = mfg.getMemberGroupDetails();
            }
            mgd = current == null ? MemberGroupDetails.create((Database)db) : current;
            int upto = Math.min(15, details.size());
            for (int i = 1; i <= upto; ++i) {
                boolean canSet;
                String value = details.get(i - 1);
                if (value == null) continue;
                boolean bl = canSet = force ? config.isDefined(i) : config.isEditable(i);
                if (!canSet) continue;
                mgd.setField(i, value);
            }
            if (current == null) {
                mgd = mgd.insert(db);
                if (tr != null) {
                    tr.commit(true);
                }
            }
        }
        return mgd;
    }

    public static List<String> toFieldValues(GeneratorRequest req) {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 1; i <= 15; ++i) {
            String field = req.getParameter("field" + i);
            fields.add(field);
        }
        return fields;
    }

    public static List<String> toFieldValues(HttpServletRequest req) {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 1; i <= 15; ++i) {
            String field = req.getParameter("field" + i);
            fields.add(field);
        }
        return fields;
    }

    private static class TypeCollector
    implements FileFilter {
        private final Set<String> _types;

        public TypeCollector(Set<String> types) {
            this._types = types;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            if (!file.isDirectory() && name.endsWith(".xml")) {
                this._types.add(name.substring(0, name.length() - 4));
                return true;
            }
            return false;
        }
    }
}

