/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberForGroupStatus;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemberForGroupRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberForGroupRule.class);
    private static final Integer DEFAULT_HTTP_PORT = 80;
    public static final Comparator<Membership> SORT_MEMBERSHIP_BY_MEMBER_NAME = new Comparator<Membership>(){

        @Override
        public int compare(Membership m1, Membership m2) {
            String f1 = m1.getMember().getSurname() + " " + m1.getMember().getFirstName();
            String f2 = m2.getMember().getSurname() + " " + m2.getMember().getFirstName();
            return f1.compareTo(f2);
        }
    };

    private MemberForGroupRule() {
    }

    public static List<Membership> getGroupMemberships(@Nullable Collection<GroupForGroup> subgroups, @Nullable Collection<MemberForGroup> mfgs) {
        Member m;
        Group mainGroup = null;
        HashMap<Group, GroupForGroup> subgroupsByGroup = new HashMap<Group, GroupForGroup>();
        if (subgroups != null) {
            for (GroupForGroup subgroup : subgroups) {
                subgroupsByGroup.put(subgroup.getMemberGroup(), subgroup);
                mainGroup = subgroup.getGroup();
            }
        }
        HashMap<Member, Membership> memberships = new HashMap<Member, Membership>();
        ArrayList<MemberForGroup> deleted = new ArrayList<MemberForGroup>();
        if (mfgs != null) {
            for (MemberForGroup mfg : mfgs) {
                m = mfg.getMember();
                Group g = mfg.getGroup();
                if (mainGroup == null || mainGroup.getId().longValue() == g.getId().longValue()) {
                    if (MemberForGroupRule.isDeletedMember(mfg)) {
                        deleted.add(mfg);
                        continue;
                    }
                    memberships.put(m, new Membership(mfg));
                    continue;
                }
                GroupForGroup subgroup = (GroupForGroup)subgroupsByGroup.get(g);
                if (subgroup == null || g.getId().longValue() != subgroup.getMemberGroup().getId().longValue()) continue;
                Membership membership = (Membership)memberships.get(m);
                if (membership == null) {
                    membership = new Membership(subgroup.getGroup(), m);
                    memberships.put(m, membership);
                    membership.addSubGroup(subgroup, mfg);
                    continue;
                }
                if (!membership.isSubGroupMember()) continue;
                membership.addSubGroup(subgroup, mfg);
            }
        }
        for (MemberForGroup mfg : deleted) {
            m = mfg.getMember();
            if (memberships.get(m) != null) continue;
            memberships.put(m, new Membership(mfg));
        }
        return new ArrayList<Membership>(memberships.values());
    }

    public static List<Membership> getMemberMemberships(Collection<MemberForGroup> mfgs, boolean includeSubgroups, Database db) throws QueryFailedException {
        HashMap<Group, Membership> memberships = new HashMap<Group, Membership>();
        if (mfgs != null) {
            for (MemberForGroup mfg : mfgs) {
                Collection subgroups;
                Member m = mfg.getMember();
                Group g = mfg.getGroup();
                memberships.put(g, new Membership(mfg));
                if (!includeSubgroups || MemberForGroupStatus.NORMAL != MemberForGroupRule.getStatus(mfg) || GroupRule.isArchived(g) || (subgroups = DatabaseQuery.getGroupForGroupsBySubGroup((Database)db, (Long)g.getId())) == null || subgroups.isEmpty()) continue;
                for (GroupForGroup subgroup : subgroups) {
                    Membership membership = (Membership)memberships.get(subgroup.getGroup());
                    if (membership != null && !membership.isSubGroupMember()) continue;
                    if (membership == null) {
                        membership = new Membership(subgroup.getGroup(), m);
                        memberships.put(subgroup.getGroup(), membership);
                    }
                    membership.addSubGroup(subgroup, mfg);
                }
            }
        }
        return new ArrayList<Membership>(memberships.values());
    }

    public static @Nullable Membership getMembership(Group group, Member member, boolean includeSubgroups, boolean deleted, Database db) throws QueryFailedException {
        if (member == null || group == null) {
            return null;
        }
        Membership membership = null;
        Collection mfgs = DatabaseQuery.getMemberForGroupsByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)member.getId(), (boolean)includeSubgroups);
        for (MemberForGroup mfg : mfgs) {
            if (mfg.getGroup().getId().longValue() == group.getId().longValue() && (deleted || !MemberForGroupRule.isDeletedMember(mfg))) {
                membership = new Membership(mfg);
                break;
            }
            if (!includeSubgroups || MemberForGroupRule.isDeletedMember(mfg)) continue;
            GroupForGroup subgroup = DatabaseQuery.getGroupForGroupByMainGroupSubGroup((Database)db, (Long)group.getId(), (Long)mfg.getGroup().getId());
            if (membership == null) {
                membership = new Membership(group, member);
            }
            if (subgroup == null) continue;
            membership.addSubGroup(subgroup, mfg);
        }
        return membership;
    }

    public static MemberForGroup register(Database db, Transaction tr, Member mem, Group grp, String notify, boolean listed, MemberGroupDetails mgd, boolean forceRegister) throws DatabaseException {
        MemberForGroup mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)grp.getId(), (Long)mem.getId());
        if (mfg != null) {
            mfg.setNotification(notify);
            mfg.setListed(Boolean.valueOf(listed));
            if (mfg.getEditorFlags() == null || mfg.getEditorFlags().indexOf(110) == -1) {
                mfg.setEditor(Boolean.valueOf(grp.getFlags() != null && grp.getFlags().contains("t")));
            }
            if ((forceRegister || grp.getFlags() == null || !grp.getFlags().contains("r") && !grp.getFlags().contains("c")) && mfg.getEditorFlags() != null) {
                mfg.setEditorFlags(mfg.getEditorFlags().replaceAll("([dnsm])", ""));
            }
            if (mgd != null) {
                mfg.setMemberGroupDetails(mgd);
            }
        } else {
            mfg = MemberForGroup.create((Database)db);
            mfg.setNotification(notify);
            mfg.setListed(Boolean.valueOf(listed));
            mfg.setMember(mem);
            mfg.setEditor(Boolean.valueOf(grp.getFlags() != null && grp.getFlags().contains("t")));
            if (!forceRegister && grp.getFlags() != null && (grp.getFlags().contains("r") || grp.getFlags().contains("c"))) {
                mfg.setEditorFlags("sd");
            }
            grp.addMembersForGroup(mfg);
            if (mgd != null) {
                mfg.setMemberGroupDetails(mgd);
            }
            mfg.insert(db);
            tr.commit(true);
        }
        new UserDetailsManager().remove(mem.getId());
        return mfg;
    }

    public static boolean isDeletedMember(MemberForGroup mfg) {
        return mfg != null && mfg.getEditorFlags() != null && mfg.getEditorFlags().indexOf(100) != -1;
    }

    public static Role getRole(MemberForGroup mfg) {
        boolean moderator;
        boolean editor;
        String flags = mfg.getEditorFlags();
        Role r = Role.forFlagsEditorModerator((String)flags, (boolean)(editor = mfg.getEditor() == null ? false : mfg.getEditor()), (boolean)(moderator = mfg.getModerator() != null));
        if (r == null) {
            String groupname = mfg.getGroup() != null ? mfg.getGroup().getName() : null;
            String username = mfg.getMember() != null ? mfg.getMember().getUsername() : null;
            LOGGER.error("Invalid membership ID: {}, group: {}, username: {}, flags: {}, editor: {}, moderator: {}", new Object[]{mfg.getId(), groupname, username, flags, editor, moderator});
            r = Role.REVIEWER;
        }
        return r;
    }

    public static MemberForGroupStatus getStatus(MemberForGroup mfg) {
        boolean moderated;
        String flags = mfg.getEditorFlags();
        if (flags == null) {
            return MemberForGroupStatus.NORMAL;
        }
        boolean disabled = flags.indexOf(100) != -1;
        boolean invited = flags.indexOf(110) != -1;
        boolean self_invited = flags.indexOf(115) != -1;
        boolean bl = moderated = flags.indexOf(109) != -1;
        if (!(disabled || invited || self_invited || moderated)) {
            return MemberForGroupStatus.NORMAL;
        }
        if (disabled && invited && !self_invited && !moderated) {
            return MemberForGroupStatus.INVITED;
        }
        if (disabled && !invited && self_invited && !moderated) {
            return MemberForGroupStatus.SELF_INVITED;
        }
        if (disabled && !invited && !self_invited && moderated) {
            return MemberForGroupStatus.MODERATED;
        }
        if (disabled && !invited && !self_invited && !moderated) {
            return MemberForGroupStatus.DISABLED;
        }
        return MemberForGroupStatus.UNKNOWN;
    }
}

