/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.HostAlias;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class HostRule {
    private HostRule() {
    }

    public static String resolveAlias(Database db, String hostname) throws QueryFailedException {
        String resolved = hostname;
        if (resolved != null) {
            resolved = resolved.toLowerCase();
            while (resolved.endsWith(".")) {
                resolved = resolved.substring(0, resolved.length() - 1);
            }
            HostAlias alias = DatabaseQuery.getHostAliasByName((Database)db, (String)resolved);
            if (alias != null) {
                resolved = alias.getHost().getName();
            }
        }
        return resolved;
    }

    public static @Nullable Host resolveHost(Database db, @Nullable String hostAlias) throws QueryFailedException {
        if (hostAlias != null) {
            hostAlias = hostAlias.toLowerCase();
            while (hostAlias.endsWith(".")) {
                hostAlias = hostAlias.substring(0, hostAlias.length() - 1);
            }
            HostAlias alias = DatabaseQuery.getHostAliasByName((Database)db, (String)hostAlias);
            if (alias != null) {
                return alias.getHost();
            }
            return DatabaseQuery.getHostByName((Database)db, (String)hostAlias);
        }
        return null;
    }

    public static Host createHost(Database db, String hostname, boolean external) throws DatabaseException {
        Objects.requireNonNull(hostname);
        String name = hostname.toLowerCase();
        try {
            new URL("http", name, "/");
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid host name " + hostname);
        }
        Host h = DatabaseQuery.getHostByName((Database)db, (String)name);
        if (h != null) {
            throw new DatabaseException("Host already exists: " + name);
        }
        Host host = Host.create((Database)db);
        host.setExternal(Boolean.valueOf(external));
        host.setName(name);
        return host.insert(db);
    }
}

