/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIData;
import com.pageseeder.base.rule.Thumbnails;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.WebTransaction;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.GroupURIs;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupURIRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupURIRule.class);

    private GroupURIRule() {
    }

    public static boolean getCachedAccess(@Nullable HttpSession session, String uriString) {
        boolean res;
        block8: {
            if (session == null) {
                return false;
            }
            res = false;
            try {
                Integer urlPort;
                WebTransaction wtr = new WebTransaction(session, "Login", false);
                Collection guris = (Collection)wtr.get("cachedGroupURIs");
                if (guris == null) break block8;
                Iterator gurii = guris.iterator();
                URL url = new URL(uriString);
                Integer n = urlPort = url.getPort() == -1 ? Integer.valueOf(80) : Integer.valueOf(url.getPort());
                while (gurii.hasNext()) {
                    GroupURIData gurid = (GroupURIData)gurii.next();
                    if (!url.getProtocol().equals(gurid.getScheme()) || !urlPort.equals(gurid.getPort()) || !url.getHost().equals(gurid.getHostName())) continue;
                    String path = gurid.getPath().toLowerCase();
                    String upath = url.getFile().toLowerCase();
                    if (path.endsWith("/*")) {
                        if ((upath.length() < path.length() - 1 || !path.substring(0, path.length() - 1).equals(upath.substring(0, path.length() - 1))) && !path.substring(0, path.length() - 2).equals(upath)) continue;
                        res = true;
                    } else if (path.endsWith("/")) {
                        if ((upath.length() < path.length() || !path.equals(upath.substring(0, path.length())) || upath.indexOf(47, path.length()) != -1) && !path.substring(0, path.length() - 1).equals(upath)) continue;
                        res = true;
                    } else {
                        if (!path.equals(upath)) continue;
                        res = true;
                    }
                    break;
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Unable to retrieve cached group URI", (Throwable)ex);
            }
        }
        return res;
    }

    public static String getURIString(GroupURI guri) {
        Host host = guri.getHost();
        return URLs.asString((String)guri.getScheme(), (String)(host != null ? host.getName() : ""), (int)guri.getPort(), (String)guri.getPath());
    }

    public static String buildLocalHashSource(GroupURI guri) {
        Host host = guri.getHost();
        return guri.getId() + 47L + guri.getScheme() + "/" + (host != null ? host.getName() : "") + "/" + guri.getPort() + "/" + guri.getPath();
    }

    public static GroupURIForGroup addGroupURIToGroup(Group group, GroupURI guri, boolean editable, Database db) throws DatabaseException {
        GroupURIForGroup gfg = GroupURIForGroup.create((Database)db);
        gfg.setGroup(group);
        gfg.setGroupURI(guri);
        gfg.setEditURIs(Boolean.valueOf(editable));
        group.addGroupURIs(gfg);
        guri.addGroups(gfg);
        gfg.insert(db);
        return gfg;
    }

    public static GroupURI addGroupURIForSchemeHostPortPath(Database db, @Nullable Group pub, Collection<GroupURI> pub_guri, Group grp, Collection<GroupURI> grp_uric, String scheme_new, String host_new, Integer port_new, String path_new, boolean isPublic, boolean editable) throws DatabaseException {
        GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)scheme_new, (String)host_new, (Integer)port_new, (String)path_new);
        if (guri != null) {
            if (!grp_uric.contains(guri)) {
                GroupURIRule.addGroupURIToGroup(grp, guri, editable, db);
            }
        } else {
            guri = GroupURI.create((Database)db);
            guri.setScheme(scheme_new);
            Host host = DatabaseQuery.getHostByName((Database)db, (String)host_new);
            guri.setHost(host);
            guri.setPath(path_new);
            guri.setPort(port_new);
            GroupURIRule.updateURIs(db, guri);
            guri = guri.insert(db);
            GroupURIRule.addGroupURIToGroup(grp, guri, editable, db);
        }
        if (isPublic && pub != null && !pub_guri.contains(guri)) {
            GroupURIRule.addGroupURIToGroup(pub, guri, editable, db);
        } else if (!isPublic && pub != null && pub_guri.contains(guri)) {
            pub.removeGroupURIs(guri);
        }
        return guri;
    }

    public static boolean belongsToGroup(GroupURI guri, String group) throws DatabaseException {
        boolean res = false;
        Iterator grpi = guri.getGroups();
        while (grpi.hasNext()) {
            Group grp = (Group)grpi.next();
            if (!group.equals(grp.getName())) continue;
            res = true;
            break;
        }
        return res;
    }

    public static void deleteGroupURI(@Nullable GroupURI guri, Group grp, Database db) throws DatabaseException {
        if (guri == null) {
            return;
        }
        if (guri.getPath().endsWith("/%")) {
            String realPath = URIRule.getRealPath(Settings.getContextPath(), GroupURIs.truncatePath((String)guri.getPath()));
            File dir = new File(realPath);
            if (dir.isDirectory() && dir.list() != null && dir.list().length == 0) {
                dir.delete();
            }
        } else {
            Collection uris = DatabaseQuery.getURIsByGroupURI((Database)db, (GroupURI)guri);
            ArrayList<Long> uriids = new ArrayList<Long>();
            for (URI u : uris) {
                uriids.add(u.getId());
            }
            uris = null;
            Transaction tr = new Transaction(db);
            tr.commitAndStart();
            int counter = 0;
            for (Long uid : uriids) {
                Publication pub = DatabaseQuery.getPublicationByRootURIID((Database)db, (Long)uid);
                if (pub != null) {
                    Publications.deletePermanently(db, pub);
                    ++counter;
                }
                if (counter % 1000 != 0) continue;
                tr.commitAndStart();
            }
            Date del_date = new Date();
            for (Long uid : uriids) {
                URI suburi = DatabaseQuery.getURIById((Database)db, (Long)uid);
                Collection xuris = DatabaseQuery.getURIsByURIXRefsAllGroups((Database)db, (URI)suburi, (boolean)false);
                for (URI xuri : xuris) {
                    if (uriids.contains(xuri.getId())) continue;
                    xuri.setLastModified(del_date);
                }
                long id = suburi.getId();
                String type = suburi.getType();
                URIRule.deleteURI(db, suburi, null);
                Thumbnails.deleteThumbnails(id, type);
                if (++counter % 1000 != 0) continue;
                tr.commitAndStart();
            }
            if (!URIRule.isExternal(guri) && guri.getPath().endsWith("/*")) {
                URIRule.deleteDirectory(GroupURIs.truncatePath((String)guri.getPath()));
            }
        }
        for (Group group : guri.getGroupsCol()) {
            group.removeGroupURIs(guri);
            guri.removeGroups(group);
        }
        guri.delete(db);
    }

    public static void updateURIs(Database db, GroupURI guri) throws DatabaseException {
        Collection cur_uri = DatabaseQuery.getURIsByGroupURI((Database)db, (GroupURI)guri);
        Collection new_uri = null;
        String path = guri.getPath();
        if (path.endsWith("/*")) {
            new_uri = DatabaseQuery.getURIsBySchemeHostPortSubpathCol((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path.substring(0, path.length() - 1));
            new_uri.addAll(DatabaseQuery.getURIsBySchemeHostPortPathCol((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path.substring(0, path.length() - 2)));
        } else if (path.endsWith("/")) {
            new_uri = DatabaseQuery.getURIsBySchemeHostPortDirectoryMediaDocumentType((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path, null, null, (boolean)false);
            new_uri.addAll(DatabaseQuery.getURIsBySchemeHostPortPathCol((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path.substring(0, path.length() - 1)));
        } else {
            new_uri = DatabaseQuery.getURIsBySchemeHostPortPathCol((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path);
        }
        for (URI uri : cur_uri) {
            if (new_uri.contains(uri)) continue;
            uri.removeGroupURIs(guri);
        }
        for (URI uri : new_uri) {
            if (cur_uri.contains(uri)) continue;
            uri.addGroupURIs(guri);
        }
    }

    public static @Nullable GroupURI getDefaultGroupURI(@Nullable Group grp) throws GetCollectionException {
        if (grp == null) {
            return null;
        }
        GroupURI defaultGuri = null;
        String defaultPath = GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', '/') + "/*";
        String defaultProjectPath = GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', '/') + "/%";
        Iterator gurii = grp.getGroupURIs();
        while (gurii.hasNext()) {
            GroupURI guri = (GroupURI)gurii.next();
            if (!defaultPath.equals(guri.getPath()) && !defaultProjectPath.equals(guri.getPath()) || URIRule.isExternal(guri)) continue;
            defaultGuri = guri;
            break;
        }
        return defaultGuri;
    }

    public static boolean isDefaultGroupURI(GroupURI guri, Group group) {
        String defaultPath = GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/*";
        return defaultPath.equals(guri.getPath()) && !URIRule.isExternal(guri);
    }

    public static boolean isGeneralGroupURI(GroupURI guri, Group group) {
        String generalPath = GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + group.getId();
        return (generalPath.equals(guri.getPath()) || (generalPath + "/*").equals(guri.getPath())) && !URIRule.isExternal(guri);
    }

    public static boolean isShared(Database db, GroupURI groupuri) throws QueryFailedException {
        URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)groupuri.getScheme(), (String)groupuri.getHost().getName(), (Integer)groupuri.getPort(), (String)GroupURIs.truncatePath((String)groupuri.getPath()));
        if (uri != null) {
            return DatabaseQuery.getNumberGroupsByURIId((Database)db, (Long)uri.getId()) > 1;
        }
        return false;
    }

    public static @Nullable GroupURI getSharedAncestorOrDescendant(String scheme, String host, Integer port, String path, boolean descendant, Database db) throws QueryFailedException {
        Collection existing = DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol((Database)db, (String)scheme, (String)host, (Integer)port, (String)path, (boolean)descendant, (boolean)false);
        if (!existing.isEmpty()) {
            return existing.stream().filter(gu -> {
                try {
                    return GroupURIRule.isShared(db, gu) && !gu.getGroupURIForGroupsCol().isEmpty();
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to check if {} group folder {} is shared", new Object[]{descendant ? "descendant" : "ancestor", gu.getPath(), ex});
                    return false;
                }
            }).findFirst().orElse(null);
        }
        return null;
    }

    public static @Nullable Group getDefaultGroup(Database db, @Nullable GroupURI guri) {
        Collection<GroupURI> guris;
        if (guri == null || URIRule.isExternal(guri)) {
            return null;
        }
        try {
            guris = URIRule.matchGroupURIs(db, guri.getScheme(), guri.getHost().getName(), guri.getPort(), GroupURIs.truncatePath((String)guri.getPath()));
        }
        catch (DatabaseException e) {
            return null;
        }
        Group found = null;
        for (GroupURI gu : guris) {
            for (Group g : gu.getGroupsCol()) {
                if (!GroupURIRule.isDefaultGroupURI(gu, g) || found != null && found.getName().length() >= g.getName().length()) continue;
                found = g;
            }
        }
        return found;
    }

    public static Group getGroupForGroupURI(Database db, Long guriId, UserDetails userDetails) throws DatabaseException {
        if (guriId == null) {
            return null;
        }
        Set<String> disp_grps = userDetails.flags().keySet();
        GroupURI guri = DatabaseQuery.getGroupURIById((Database)db, (Long)guriId);
        Collection grps = guri.getGroupsCol();
        Group def_grp = null;
        for (Group group : grps) {
            if (!GroupURIRule.isDefaultGroupURI(guri, group) || !disp_grps.contains((def_grp = group).getName())) continue;
            return def_grp;
        }
        Iterator grpi = grps.iterator();
        Group grp = null;
        while (grpi.hasNext()) {
            Group temp_grp = (Group)grpi.next();
            if (GroupRule.isPublicGroup(temp_grp.getName())) continue;
            if (disp_grps.contains(temp_grp.getName())) {
                grp = temp_grp;
                def_grp = null;
                break;
            }
            if (grp == null) {
                grp = temp_grp;
                continue;
            }
            if (grp.getFlags() != null && grp.getFlags().indexOf(112) != -1 || temp_grp.getFlags() == null || temp_grp.getFlags().indexOf(112) == -1) continue;
            grp = temp_grp;
            def_grp = null;
        }
        return def_grp != null ? def_grp : grp;
    }

    public static Collection<URI> checkForFolderURIs(GroupURI guri, Member member, Database db) throws DatabaseException {
        ArrayList<URI> created = new ArrayList<URI>();
        if (guri.getPath().endsWith("/%")) {
            return created;
        }
        if (URIRule.isExternal(guri)) {
            return created;
        }
        String path = GroupURIs.truncatePath((String)guri.getPath());
        URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path);
        if (uri == null) {
            String realpath = URIRule.getRealPath(Settings.getContextPath(), path);
            File directory = new File(realpath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!directory.exists()) {
                LOGGER.error("Failed to create folder on the file system {}", (Object)path);
            } else {
                uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, null, guri.getScheme(), guri.getHost().getName(), guri.getPort(), path, null, null, null, "folder", true);
                if (uri == null) {
                    LOGGER.error("Failed to create folder URI {}", (Object)path);
                } else {
                    created.add(uri);
                    URIRule.addURIHistoryXLink(uri, member, uri.getDateCreated(), "creation", null, db);
                }
            }
        }
        if (guri.getPath().endsWith("/*")) {
            Collection subguris = DatabaseQuery.getGroupURIsBySchemeHostPortSubpathCol((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path);
            for (GroupURI subguri : subguris) {
                if (subguri.getId().longValue() == guri.getId().longValue()) continue;
                created.addAll(GroupURIRule.createFolderURIs(guri, subguri, member, db));
            }
        }
        Object guriPath = "";
        for (String folder : path.substring(1).split("/")) {
            GroupURI ancestorGuri;
            if (((String)(guriPath = (String)guriPath + "/" + (String)folder)).equals(path) || (ancestorGuri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)((String)guriPath + "/*"))) == null) continue;
            created.addAll(GroupURIRule.createFolderURIs(ancestorGuri, guri, member, db));
            break;
        }
        return created;
    }

    private static Collection<URI> createFolderURIs(GroupURI ancestor, GroupURI descendant, Member member, Database db) throws DatabaseException {
        String ancestorPath = GroupURIs.truncatePath((String)ancestor.getPath());
        String descendantPath = GroupURIs.truncatePath((String)descendant.getPath());
        ArrayList<URI> created = new ArrayList<URI>();
        if (descendantPath.startsWith(ancestorPath + "/")) {
            String between = descendantPath.substring(ancestorPath.length() + 1);
            Object uriPath = ancestorPath;
            for (String folder : between.split("/")) {
                uriPath = (String)uriPath + "/" + folder;
                URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)ancestor.getScheme(), (String)ancestor.getHost().getName(), (Integer)ancestor.getPort(), (String)uriPath);
                if (uri != null) continue;
                String realpath = URIRule.getRealPath(Settings.getContextPath(), (String)uriPath);
                File directory = new File(realpath);
                if (!directory.exists()) {
                    directory.mkdirs();
                    if (!directory.exists()) {
                        LOGGER.error("Failed to create folder on the file system {}", uriPath);
                        break;
                    }
                }
                if ((uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, null, ancestor.getScheme(), ancestor.getHost().getName(), ancestor.getPort(), (String)uriPath, null, null, null, "folder", true)) == null) {
                    LOGGER.error("Failed to create folder URI {}", uriPath);
                    continue;
                }
                created.add(uri);
                URIRule.addURIHistoryXLink(uri, member, uri.getDateCreated(), "creation", null, db);
            }
        }
        return created;
    }
}

