/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.inspect.FileInspection;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.GroupForXLink;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.URIs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupRule.class);
    public static final String ADMIN_GROUP = "admin";
    public static final String PUBLIC_GROUP = "public";
    public static final String MEMBER_PROJECT = "member";
    public static final String ARCHIVE_PROJECT = "archive";
    private static final String REGEX_GROUP_NAME = "^[a-z][a-z0-9_~\\-]+$";
    public static final Collection<String> RESERVED_PROJECT_NAMES = Arrays.asList("public", "admin", "member", "archive", "default");

    private GroupRule() {
    }

    public static boolean isAdminGroup(String name) {
        return ADMIN_GROUP.equals(name);
    }

    public static boolean isPublicGroup(String name) {
        return PUBLIC_GROUP.equals(name);
    }

    public static boolean isPersonalGroup(@Nullable String name) {
        return name != null && name.startsWith("member-");
    }

    public static boolean userHasAccess(Group group, Permissions perm) {
        Collection<String> groups = perm.getDisplayGroups();
        return groups.contains(group.getName()) || group.hasFlag('p') || perm.getAdminSystem();
    }

    public static boolean userHasAccess(Group group, UserDetails userDetails) {
        return userDetails.flags().containsKey(group.getName()) || group.hasFlag('p') || userDetails.flags().containsKey(ADMIN_GROUP);
    }

    public static boolean hasModerator(Group grp, Database db) {
        try {
            return DatabaseQuery.getModeratorByGroupId((Database)db, (Long)grp.getId(), (boolean)false) != null;
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load group moderator", (Throwable)ex);
            return false;
        }
    }

    public static Group getMemberProject(Database db) throws DatabaseException {
        Group project = DatabaseQuery.getGroupByName((Database)db, (String)MEMBER_PROJECT);
        if (project == null) {
            project = Group.create((Database)db);
            project.setName(MEMBER_PROJECT);
            project.setDescription("Personal member groups");
            project.setControlGroupName(MEMBER_PROJECT);
            project.setOwnerDirectory(MEMBER_PROJECT);
            project.setOwner("PS");
            project.setFlags("fn");
            project = project.insert(db);
            File groupDirectory = new File(Settings.getDocumentPath(), MEMBER_PROJECT);
            if (!groupDirectory.exists() && !groupDirectory.mkdirs()) {
                throw new DatabaseException("Directory " + groupDirectory.getAbsolutePath() + " could not be created.");
            }
            GroupURI guri = GroupURI.create((Database)db);
            guri.setScheme(Settings.getDocumentScheme());
            Host host = DatabaseQuery.getHostByName((Database)db, (String)GlobalSettings.get((String)"webSiteAddress"));
            guri.setHost(host);
            guri.setPath(GlobalSettings.getSitePrefix() + "/member/%");
            guri.setPort(Integer.valueOf(Settings.getDocumentPort()));
            GroupURIRule.addGroupURIToGroup(project, guri, false, db);
            GroupURIRule.updateURIs(db, guri);
            GroupURI groupURI = guri.insert(db);
        }
        return project;
    }

    public static @Nullable Group getMemberPersonalProject(Database db, Member member) throws DatabaseException {
        return DatabaseQuery.getGroupByName((Database)db, (String)("member-" + member.getId()));
    }

    public static String getTemplate(Group group) {
        return GroupRule.isProject(group) ? group.getName() : group.getOwnerDirectory();
    }

    public static @Nullable Group getTemplateProject(Database db, Group group) throws DatabaseException {
        if (group.getOwnerDirectory() == null) {
            return null;
        }
        return DatabaseQuery.getGroupByName((Database)db, (String)group.getOwnerDirectory());
    }

    public static @Nullable Group getMemberPersonalGroup(Database db, Member member) throws DatabaseException {
        return DatabaseQuery.getGroupByName((Database)db, (String)GroupRule.getMemberPersonalGroupName(member.getId()));
    }

    public static String getMemberPersonalGroupName(Long memberId) {
        return "member-" + memberId + "-home";
    }

    public static @Nullable Group createMemberPersonalGroup(Database db, Member member, Group parentProject, @Nullable String commenting) throws DatabaseException {
        Group group = GroupRule.getMemberPersonalGroup(db, member);
        if (group != null) {
            return null;
        }
        group = Group.create((Database)db);
        String groupName = GroupRule.getMemberPersonalGroupName(member.getId());
        group.setName(groupName);
        group.setDescription("Home group for member " + member.getId());
        group.setControlGroupName(groupName);
        group.setOwner("PS");
        group.setOwnerDirectory("member-" + member.getId());
        if (PUBLIC_GROUP.equals(commenting)) {
            group.setFlags("nea");
        } else if ("contributor".equals(commenting)) {
            group.setFlags("neo");
        } else {
            group.setFlags("ne");
        }
        group = group.insert(db);
        GroupURI parentGuri = GroupURIRule.getDefaultGroupURI(parentProject);
        List<GroupURI> empty = Collections.emptyList();
        GroupURIRule.addGroupURIForSchemeHostPortPath(db, null, empty, group, empty, parentGuri.getScheme(), parentGuri.getHost().getName(), parentGuri.getPort(), GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + group.getId() + "/*", false, false);
        GroupURI guri = GroupURIRule.addGroupURIForSchemeHostPortPath(db, null, empty, group, empty, parentGuri.getScheme(), parentGuri.getHost().getName(), parentGuri.getPort(), GlobalSettings.getSitePrefix() + "/member/" + member.getId() + "/home/*", false, true);
        if (guri != null) {
            String path = GroupURIs.truncatePath((String)guri.getPath());
            URI uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, null, guri.getScheme(), guri.getHost().getName(), guri.getPort(), path, null, null, null, "folder", true);
            if (uri == null) {
                LOGGER.error("Failed to create folder URI {}", (Object)path);
            } else {
                URIRule.addURIHistoryXLink(uri, member, uri.getDateCreated(), "creation", null, db);
            }
        }
        MemberForGroup mfg = MemberForGroup.create((Database)db);
        mfg.setNotification(Notification.IMMEDIATE.type());
        mfg.setEditorFlags("e");
        mfg.setMember(member);
        mfg.setEditor(Boolean.valueOf(true));
        mfg.setListed(Boolean.valueOf(true));
        group.addMembersForGroup(mfg);
        mfg.insert(db);
        new UserDetailsManager().remove(member.getId());
        ChangesManager.getInstance().createGroup(db, group);
        return group;
    }

    public static Group createMemberPersonalProject(Database db, Member member, Group parentProject) throws DatabaseException {
        Group project = GroupRule.getMemberPersonalProject(db, member);
        if (project == null) {
            project = Group.create((Database)db);
            String projectName = "member-" + member.getId();
            project.setName(projectName);
            project.setDescription("Personal project for member " + member.getId());
            project.setControlGroupName(projectName);
            project.setOwner("PS");
            project.setOwnerDirectory(projectName);
            project.setFlags("fne");
            project = project.insert(db);
            GroupURI parentGuri = GroupURIRule.getDefaultGroupURI(parentProject);
            GroupURI guri = GroupURI.create((Database)db);
            guri.setScheme(parentGuri.getScheme());
            guri.setHost(parentGuri.getHost());
            guri.setPath(GlobalSettings.getSitePrefix() + "/member/" + member.getId() + "/%");
            guri.setPort(parentGuri.getPort());
            GroupURIRule.addGroupURIToGroup(project, guri, false, db);
            GroupURIRule.updateURIs(db, guri);
            guri.insert(db);
            MemberForGroup mfg = MemberForGroup.create((Database)db);
            mfg.setNotification(Notification.IMMEDIATE.type());
            mfg.setEditorFlags("e");
            mfg.setMember(member);
            mfg.setEditor(Boolean.valueOf(true));
            mfg.setListed(Boolean.valueOf(true));
            project.addMembersForGroup(mfg);
            mfg.insert(db);
            new UserDetailsManager().remove(member.getId());
        }
        return project;
    }

    public static Collection<URI> createDefaultDocuments(Group grp, Member author, Database db) throws FoundationException {
        File documentsDirectory = TemplateFiles.find((Template)new Template(grp.getOwnerDirectory()), (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)new File(Settings.getContextPath()), (String)"newgroup/psml");
        HashMap<File, Map<String, String>> copied = new HashMap<File, Map<String, String>>();
        File destination = new File(URIRule.getRealPath(Settings.getContextPath(), GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', File.separatorChar)));
        try {
            File[] files;
            if (documentsDirectory != null && documentsDirectory.exists() && documentsDirectory.isDirectory() && (destination.exists() || destination.mkdirs()) && (files = documentsDirectory.listFiles()) != null) {
                for (File oldOne : files) {
                    File newOne = new File(destination, oldOne.getName());
                    if (oldOne.isDirectory()) {
                        copied.putAll(GroupRule.copyDirectory(oldOne, newOne));
                        continue;
                    }
                    if (!oldOne.isFile()) continue;
                    copied.put(newOne, GroupRule.copyFile(oldOne, newOne));
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to copy new group documents for group {}", (Object)grp.getName(), (Object)ex);
            throw new FoundationException("Failed to copy new documents", ex);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            GroupURI guri = GroupURIRule.getDefaultGroupURI(grp);
            if (guri == null) {
                return uris;
            }
            String guripath = GroupURIs.truncatePath((String)guri.getPath());
            for (Map.Entry e : copied.entrySet()) {
                URI otherURI;
                File file = (File)e.getKey();
                Map attributes = (Map)e.getValue();
                String relativePath = com.pageseeder.common.io.Files.path((File)destination, (File)file);
                String[] filename = URIRule.getFilename(relativePath);
                String fullpath = guripath + "/" + RuleUtils.urlEncodeFilepath(relativePath);
                String ext = Strings.isEmpty((String)filename[1]) ? null : filename[1].substring(1);
                String title = (String)attributes.get("title");
                String type = (String)attributes.get("type");
                String behavior = (String)attributes.get("behavior");
                URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)fullpath);
                if (uri != null) {
                    throw new FoundationException("URI " + fullpath + " already exists");
                }
                String labels = (String)attributes.get("labels");
                if (type == null && file.isDirectory()) {
                    type = "folder";
                } else if (type == null && ext != null) {
                    type = Medias.getMediaType(ext);
                }
                uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels(db, null, guri.getScheme(), guri.getHost().getName(), guri.getPort(), fullpath, behavior, null, title, type, labels == null ? null : Strings.split((String)labels, (char)','), false);
                String docid = (String)attributes.get("docid");
                if (docid != null && uri.getDocID() == null && (otherURI = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)uri.getHost().getName(), (String)docid)) == null) {
                    if (!URIRule.isValidDocumentID(docid)) {
                        throw new FoundationException("Invalid Document ID " + docid);
                    }
                    uri.setDocID(docid);
                }
                byte[] content = null;
                if (URIRule.isPSML(uri)) {
                    content = Files.readAllBytes(file.toPath());
                    if (!file.delete()) {
                        LOGGER.warn("Failed to delete old file: " + file.getAbsolutePath());
                        file.deleteOnExit();
                    }
                }
                URIRule.addURIHistoryXLink(uri, author, uri.getDateCreated(), null, "creation", null, null, null, content, db);
                uris.add(uri);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to create new group documents URI for group {}", (Object)grp.getName(), (Object)ex);
            throw new FoundationException("Failed to create URI ", ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to compute File path: {}", (Throwable)ex);
            throw new FoundationException("Failed to compute file path", ex);
        }
        return uris;
    }

    public static boolean containsAdminGroup(Collection<Group> groups) {
        for (Group group : groups) {
            if (!ADMIN_GROUP.equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPublicGroup(Collection<Group> groups) {
        for (Group group : groups) {
            if (!PUBLIC_GROUP.equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubGroup(Collection<Group> groups, Group group) {
        for (Group g : groups) {
            Collection subgroups = g.getMemberGroups();
            for (GroupForGroup subgroup : subgroups) {
                if (!subgroup.getMemberGroup().equals((Object)group)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<File, Map<String, String>> copyDirectory(File in, File out) throws IOException {
        HashMap<File, Map<String, String>> copied = new HashMap<File, Map<String, String>>();
        if (out.mkdir() || out.exists() && out.isDirectory()) {
            copied.put(out, Collections.singletonMap("type", "folder"));
            File[] toCopy = in.listFiles();
            if (toCopy == null) {
                throw new IllegalArgumentException("Unable to list files of directory to copy");
            }
            for (File oldOne : toCopy) {
                File newOne = new File(out, oldOne.getName());
                if (oldOne.isDirectory()) {
                    copied.putAll(GroupRule.copyDirectory(oldOne, newOne));
                    continue;
                }
                if (!oldOne.isFile()) continue;
                copied.put(newOne, GroupRule.copyFile(oldOne, newOne));
            }
        }
        return copied;
    }

    private static Map<String, String> copyFile(@Nullable File in, @Nullable File out) throws IOException {
        if (in == null || !in.exists() || out == null) {
            return Collections.emptyMap();
        }
        if (!out.exists() && !out.createNewFile()) {
            throw new IOException("Could not create new file " + out.getAbsolutePath());
        }
        FileUtils.copyFile((File)in, (File)out);
        return FileInspection.inspect(in);
    }

    public static boolean isArchived(Group g) {
        return g.hasFlag('d');
    }

    public static boolean isProject(Group g) {
        return g.hasFlag('f');
    }

    public static String getTopProjectName(Group group) {
        return GroupRule.getTopProjectName(group.getName());
    }

    public static String getTopProjectName(String group) {
        int dash = group.indexOf(45);
        return dash != -1 ? group.substring(0, dash) : group;
    }

    public static @Nullable String getParentProjectName(@Nullable String group) {
        if (group == null) {
            return null;
        }
        int dash = group.lastIndexOf(45);
        return dash != -1 ? group.substring(0, dash) : null;
    }

    public static boolean areGroupsDifferent(@Nullable Collection<Group> groups1, @Nullable Collection<Group> groups2) {
        if (groups1 == null || groups2 == null) {
            return true;
        }
        for (Group group : groups1) {
            if (GroupRule.isPublicGroup(group.getName()) || groups2.contains(group)) continue;
            return true;
        }
        for (Group group : groups2) {
            if (GroupRule.isPublicGroup(group.getName()) || groups1.contains(group)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable GroupURI getFolderGroupURI(Group folderGroup) {
        Iterator gurii = folderGroup.getGroupURIs();
        GroupURI folderGuri = null;
        while (gurii.hasNext()) {
            GroupURI guri = (GroupURI)gurii.next();
            if (!guri.getPath().endsWith("/%")) continue;
            folderGuri = guri;
            break;
        }
        return folderGuri;
    }

    public static Group getPublicGroup(Database db) throws QueryFailedException {
        return Objects.requireNonNull(DatabaseQuery.getGroupByName((Database)db, (String)PUBLIC_GROUP), "The public does not exist");
    }

    public static boolean acceptInvitationRequired(Database db, Group group) throws QueryFailedException, IOException {
        return !"false".equals(GroupProperties.get(db, group).get("acceptInvitationRequired"));
    }

    public static boolean moderationRequired(Group group) {
        return group.hasFlag('g');
    }

    public static boolean emailModerationRequired(Group group) {
        return group.hasFlag('g') || !group.hasFlag('e');
    }

    public static void ensureParentProjectsExist(String newname, Group group, Database db) throws DatabaseException {
        if (newname.indexOf(45) != -1) {
            String[] projects = Strings.split((String)newname, (char)'-');
            for (int i = 0; i < projects.length - 1; ++i) {
                StringBuilder pname = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    pname.append(j == 0 ? "" : "-").append(projects[j]);
                }
                Group project = DatabaseQuery.getGroupByName((Database)db, (String)pname.toString());
                if (project != null) continue;
                GroupRule.createArchivedProject(pname.toString(), group, db);
            }
        }
    }

    public static void createArchivedProject(String projectName, Group group, Database db) throws DatabaseException {
        Group project = Group.create((Database)db);
        project.setName(projectName);
        project.setDescription("Archived Project");
        if (ARCHIVE_PROJECT.equals(projectName)) {
            project.setFlags("df");
            project.insert(db);
            return;
        }
        if (projectName.startsWith("archive-")) {
            project.setFlags("df");
            project.setOwnerDirectory(projectName.substring(8));
        } else {
            project.setFlags("f");
            project.setOwnerDirectory(projectName);
        }
        project.insert(db);
        GroupURI parentGuri = GroupURIRule.getDefaultGroupURI(group);
        if (parentGuri != null) {
            GroupURIRule.addGroupURIForSchemeHostPortPath(db, null, Collections.emptyList(), project, Collections.emptyList(), parentGuri.getScheme(), parentGuri.getHost().getName(), parentGuri.getPort(), GlobalSettings.getSitePrefix() + "/" + project.getName().replace('-', '/') + "/%", false, false);
        } else {
            LOGGER.error("Group {} does not have a default Group URI", (Object)group.getName());
        }
    }

    public static boolean isValidGroupName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        String pjname = name;
        int dash = name.indexOf(45);
        if (dash != -1) {
            pjname = name.substring(0, dash);
        }
        return name.matches(REGEX_GROUP_NAME) && !RESERVED_PROJECT_NAMES.contains(pjname) && !name.endsWith("-silent") && !name.contains("--");
    }

    public static String getDefaultPath(Group group) {
        return GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/";
    }

    public static Collection<Group> getEditGroups(Database db, @Nullable Group group, @Nullable URI uri) throws DatabaseException {
        if (uri == null) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(GroupRule.getEditGroup(db, group, uri));
        return groups;
    }

    public static Group getEditGroup(Database db, @Nullable Group group, URI uri) throws QueryFailedException {
        if (URIs.isExternal((URI)uri)) {
            return GroupRule.getPublicGroup(db);
        }
        if (group != null && URIRule.isDefaultGroup(uri, group)) {
            return group;
        }
        return URIRule.getDefaultGroupForURINonNull(uri);
    }

    public static Collection<Group> getGroupsByNames(Database db, Collection<String> names) throws DatabaseException {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            Group group = DatabaseQuery.getGroupByName((Database)db, (String)name);
            if (group == null) {
                throw new DatabaseException("Group " + name + " not found.");
            }
            groups.add(group);
        }
        return groups;
    }

    public static Collection<String> getGroupNames(Collection<Group> groups) {
        ArrayList<String> names = new ArrayList<String>();
        for (Group group : groups) {
            names.add(group.getName());
        }
        return names;
    }

    public static @Nullable Group getGroup(Database db, @Nullable String nameOrId) throws QueryFailedException {
        if (nameOrId == null || nameOrId.isEmpty()) {
            return null;
        }
        boolean isId = Strings.isDigits((String)nameOrId);
        return isId ? DatabaseQuery.getGroupById((Database)db, (Long)Long.parseLong(nameOrId)) : DatabaseQuery.getGroupByName((Database)db, (String)nameOrId);
    }

    public static Collection<Group> getGroupsFromGroupURIForGroups(Collection<GroupURIForGroup> gurifgs) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (GroupURIForGroup gurifg : gurifgs) {
            Group group = gurifg.getGroup();
            if (groups.contains(group)) continue;
            groups.add(group);
        }
        return groups;
    }

    public static Collection<Group> removeAdminGroup(Collection<Group> groups) {
        ArrayList<Group> filtered = new ArrayList<Group>();
        for (Group grp : groups) {
            if (GroupRule.isAdminGroup(grp.getName())) continue;
            filtered.add(grp);
        }
        return filtered;
    }

    public static Collection<Group> removePublicGroup(Collection<Group> groups) {
        ArrayList<Group> filtered = new ArrayList<Group>();
        for (Group grp : groups) {
            if (GroupRule.isPublicGroup(grp.getName())) continue;
            filtered.add(grp);
        }
        return filtered;
    }

    public static Collection<Group> removeOtherNonPublicGroups(Collection<Group> groups, Collection<Group> keep) {
        ArrayList<Group> filtered = new ArrayList<Group>();
        for (Group grp : groups) {
            if (!keep.contains(grp) && !grp.hasFlag('p')) continue;
            filtered.add(grp);
        }
        return filtered;
    }

    public static Collection<Group> removeAdminOtherGroups(Collection<Group> groups, Collection<Group> remove) {
        ArrayList<Group> filtered = new ArrayList<Group>();
        for (Group grp : groups) {
            if (remove.contains(grp) || GroupRule.isAdminGroup(grp.getName())) continue;
            filtered.add(grp);
        }
        return filtered;
    }

    public static Collection<Group> removeNonURIGroupsSubgroups(Collection<Group> groups, Collection<Group> urigroups, @Nullable Long memberid) {
        ArrayList<Group> filtered = new ArrayList<Group>();
        for (Group group : groups) {
            if (!urigroups.contains(group) && (memberid == null || groups.size() != 1 || !group.getName().equals(GroupRule.getMemberPersonalGroupName(memberid))) && !GroupRule.isSubGroup(urigroups, group)) continue;
            filtered.add(group);
        }
        return filtered;
    }

    public static Collection<String> removeNonProjectGroupNames(Collection<String> names, String project) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (!name.startsWith(project + "-")) continue;
            filtered.add(name);
        }
        return filtered;
    }

    public static void deleteGroup(Database db, Group grp) throws DatabaseException, FoundationException {
        String defaultPath = GlobalSettings.getSitePrefix() + "/" + grp.getName().replace('-', '/') + "/*";
        Iterator gurii = grp.getGroupURIs();
        while (gurii.hasNext()) {
            GroupURI guri = (GroupURI)gurii.next();
            if (defaultPath.equals(guri.getPath()) || guri.getPath().endsWith("%") || GroupURIRule.isGeneralGroupURI(guri, grp)) {
                GroupURIRule.deleteGroupURI(guri, grp, db);
                continue;
            }
            guri.removeGroups(grp);
            grp.removeGroupURIs(guri);
        }
        Locator loc = grp.getDefaultLocator();
        if (loc != null) {
            Iterator lfxi = loc.getXLinksForLocator();
            while (lfxi.hasNext()) {
                LocatorForXLink lfx = (LocatorForXLink)lfxi.next();
                XLink xl = lfx.getXLink();
                if (xl == null) {
                    LOGGER.warn("Found a LocatorForXLink with a null XLink on default locator for group {}", (Object)grp.getName());
                } else {
                    XLinkRule.deleteXLink(db, xl);
                }
                lfx.delete(db);
            }
            grp.setDefaultLocator(null);
            loc.delete(db);
        }
        for (GroupForXLink gfx : DatabaseQuery.getGroupForXLinksByGroup((Database)db, (Group)grp)) {
            gfx.delete(db);
        }
        Collection mfgs = DatabaseQuery.getMemberForGroupsByGroupId((Database)db, (Long)grp.getId());
        for (MemberForGroup mfg : mfgs) {
            mfg.delete(db);
        }
        for (GroupForGroup subgroup : grp.getMemberGroups()) {
            subgroup.getGroup().removeGroupForGroup(subgroup);
            subgroup.delete(db);
        }
        for (GroupForGroup supergroup : DatabaseQuery.getGroupForGroupsBySubGroup((Database)db, (Long)grp.getId())) {
            supergroup.getGroup().removeGroupForGroup(supergroup);
            supergroup.delete(db);
        }
        grp.delete(db);
    }
}

