/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class ExternalURIFetcher
implements URIFetcher {
    private final @Nullable HttpServletRequest req;
    private final String uriString;
    protected URIFetcherStatus status = URIFetcherStatus.SUCCESS;
    protected @Nullable String statusMessage = null;
    private @Nullable InputStream uriIS = null;

    public ExternalURIFetcher(String uristring, @Nullable HttpServletRequest req) {
        this.uriString = uristring;
        this.req = req;
    }

    @Override
    public void close() throws IOException {
        if (this.uriIS != null) {
            this.uriIS.close();
        }
    }

    @Override
    public boolean getCachedAccess() {
        return this.req != null && GroupURIRule.getCachedAccess(this.req.getSession(false), this.uriString);
    }

    @Override
    public InputStream getContent() {
        if (this.uriIS == null) {
            String shortcut = "[InternetShortcut]\nURL=" + this.uriString;
            this.uriIS = new ByteArrayInputStream(shortcut.getBytes(StandardCharsets.UTF_8));
        }
        return this.uriIS;
    }

    @Override
    public @Nullable File getFile() {
        return null;
    }

    @Override
    public long getContentLength() {
        return (long)this.uriString.getBytes(StandardCharsets.US_ASCII).length + 23L;
    }

    @Override
    public String getContentType() {
        return "text/url";
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public URIFetcherStatus getStatus() {
        return this.status;
    }

    @Override
    public @Nullable String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String getURIString() {
        return this.uriString;
    }
}

