/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.publication;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateQueue
implements ChangesListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateQueue.class);
    private static final UpdateQueue SINGLETON = new UpdateQueue();
    private final LinkedBlockingQueue<Update> queue = new LinkedBlockingQueue();

    private UpdateQueue() {
    }

    public static UpdateQueue singleton() {
        return SINGLETON;
    }

    public void addUpdate(long uriid, boolean delete) {
        try {
            Update u = new Update(uriid, delete);
            if (!this.queue.contains(u)) {
                this.queue.put(u);
            } else {
                LOGGER.debug("Update for URI ID {} already in queue", (Object)u.uriid);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Update nextUpdate() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public void deleteDocument(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        if (path.endsWith(".psml")) {
            this.addUpdate(uriid, true);
        }
    }

    public static final class Update {
        public final long uriid;
        public final boolean delete;

        private Update(long uriid, boolean delete) {
            this.uriid = uriid;
            this.delete = delete;
        }

        public boolean equals(Object obj) {
            return obj instanceof Update && this.uriid == ((Update)obj).uriid && this.delete == ((Update)obj).delete;
        }

        public int hashCode() {
            return Objects.hash(this.uriid, this.delete);
        }
    }
}

