/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberForGroupStatus;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class ViewMemberGroupsCheck
extends PermissionCheck {
    private final @Nullable Member member;

    public ViewMemberGroupsCheck(@Nullable Member member) {
        this.member = member;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        Long memberId = perm.getMemberId();
        if (memberId != null && this.member != null && memberId.equals(this.member.getId())) {
            return true;
        }
        if (perm.getAdminSystem() || perm.getManageAccount()) {
            return true;
        }
        List<String> mgroupnames = MemberRule.getManagerGroupnames(perm.getUserDetails());
        for (String groupname : mgroupnames) {
            MemberForGroup mfg;
            Group gp;
            try {
                gp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            }
            catch (QueryFailedException ex) {
                LoggerFactory.getLogger(ViewMemberGroupsCheck.class).error("Unable to perform check", (Throwable)ex);
                return false;
            }
            if (gp == null || this.member == null) continue;
            try {
                mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)gp.getId(), (Long)this.member.getId());
            }
            catch (QueryFailedException ex) {
                LoggerFactory.getLogger(ViewMemberGroupsCheck.class).error("Unable to perform check", (Throwable)ex);
                return false;
            }
            if (mfg == null || MemberForGroupRule.getStatus(mfg) != MemberForGroupStatus.NORMAL) continue;
            return true;
        }
        return false;
    }
}

