/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminDatabaseCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.ArchiveGroupCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.DeleteGroupCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionException;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.AdminRule;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionManager.class);

    private PermissionManager() {
    }

    public static AccessEvent.Permission getAccessPermission(Collection<PermissionCheck> checks) {
        AccessEvent.Permission permission = AccessEvent.Permission.PUBLIC;
        for (PermissionCheck check : checks) {
            AccessEvent.Permission p = PermissionManager.getAccessPermission(check);
            if (p.compareTo(permission) >= 0) continue;
            permission = p;
        }
        return permission;
    }

    public static AccessEvent.Permission getAccessPermission(PermissionCheck check) {
        if (check instanceof AdminDatabaseCheck || check instanceof AdminSystemCheck || check instanceof DevelopCheck || check instanceof ManageAccountCheck || check instanceof ManageOAuthCheck || check instanceof ManageWebhookCheck || check instanceof CreateProjectCheck || check instanceof DeleteGroupCheck) {
            return AccessEvent.Permission.ADMINISTRATOR;
        }
        if (check instanceof ConfigureProjectCheck) {
            return AccessEvent.Permission.PROJECT_MANAGER;
        }
        if (check instanceof EditGroupCheck || check instanceof ArchiveGroupCheck) {
            if (check.grp != null && GroupRule.isProject(check.grp)) {
                return AccessEvent.Permission.PROJECT_MANAGER;
            }
            return AccessEvent.Permission.GROUP_MANAGER;
        }
        if (check instanceof ViewMemberCheck) {
            ViewMemberCheck mcheck = (ViewMemberCheck)check;
            if (mcheck.check != null) {
                return PermissionManager.getAccessPermission(mcheck.check);
            }
        }
        if (check.authenticated || !check.access) {
            return AccessEvent.Permission.MEMBER;
        }
        return AccessEvent.Permission.PUBLIC;
    }

    public static boolean check(Long memberid, UserDetails userdetails, Database db, Permissions perm, PermissionCheck check) {
        boolean access = false;
        perm.setMemberId(memberid);
        perm.setUserDetails(userdetails);
        try {
            perm.setAuthenticate(false);
            check.getPermissions(db, perm);
            if (perm.getStatus() != Permissions.Status.SUCCESS) {
                return false;
            }
            check.access = access = check.hasAccess(db, perm);
        }
        catch (PermissionException ex) {
            LOGGER.error("Unable to perform check", (Throwable)ex);
        }
        return access;
    }

    public static boolean check(HttpServletRequest req, Database db, Permissions perm, PermissionCheck check) {
        boolean access = false;
        perm.setRequest(req);
        try {
            perm.setAuthenticate(false);
            check.getPermissions(db, perm);
            if (perm.getStatus() != Permissions.Status.SUCCESS) {
                return false;
            }
            check.access = access = check.hasAccess(db, perm);
            if (access && check.checkAllowed) {
                access = PermissionManager.checkAllowed();
            }
            if (access && req != null) {
                access = PermissionManager.checkRestrictions(req.getServerName());
            }
        }
        catch (PermissionException ex) {
            LOGGER.error("Unable to perform check", (Throwable)ex);
        }
        return access;
    }

    public static boolean check(HttpServletRequest req, HttpServletResponse res, Database db, Permissions perm, PermissionCheck check, boolean output) {
        if (output) {
            return PermissionManager.check(req, res, db, perm, check);
        }
        perm.setResponse(res);
        return PermissionManager.check(req, db, perm, check);
    }

    public static boolean check(HttpServletRequest req, HttpServletResponse res, Database db, Permissions perm, PermissionCheck check) {
        perm.setResponse(res);
        if (!PermissionManager.check(req, db, perm, check)) {
            if (perm.isLoggedIn()) {
                SecurityLog.warn(SecurityLog.EventType.FORBIDDEN_ACCESS, "Attempted access to forbidden resource");
                WebRequest.sendError(req, res, 403, FrameworkErrorID.FAILED_PERMISSION_CHECK, "Access forbidden");
            } else {
                WebRequest.sendError(req, res, 401, FrameworkErrorID.FAILED_PERMISSION_CHECK, "Unauthorized access");
            }
            return false;
        }
        return true;
    }

    public static boolean checkAllowed() {
        return AdminRule.checkAllowed(GlobalSettings.getString((String)String.join((CharSequence)"", "webS", "iteA", "ddress"), (String)""));
    }

    private static boolean checkRestrictions(String sn) {
        String p1 = "pro";
        String p2 = "ductK";
        String p3 = "ey";
        String p4 = p1 + p2 + p3;
        String pk = GlobalSettings.getString((String)p4, (String)"");
        String l = String.join((CharSequence)"", "lo", "ca", "lh", "o", "s", "t");
        if (pk.equals(String.join((CharSequence)"", "de", "v")) && !sn.equals(l) && !sn.endsWith("." + l)) {
            System.out.println(p4 + ": " + sn);
            return false;
        }
        return true;
    }
}

