/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import org.slf4j.LoggerFactory;

public final class EditXLinkCheck
extends PermissionCheck {
    private boolean changeAuthor = false;
    private boolean changeCreated = false;

    public EditXLinkCheck(URI uri, XLink xl) {
        this.uri = uri;
        this.xl = xl;
    }

    public EditXLinkCheck(String uristring, XLink xl) {
        this.uriString = uristring;
        this.xl = xl;
    }

    public void setChangeAuthor(boolean changeAuthor) {
        this.changeAuthor = changeAuthor;
    }

    public void setChangeCreated(boolean changeCreated) {
        this.changeCreated = changeCreated;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        if (perm.getEditAllXLinks()) {
            return true;
        }
        assert (this.xl != null);
        if (this.changeCreated || this.changeAuthor && (this.xl.getMember() != null || !this.xl.getAuthorOnly().booleanValue())) {
            return false;
        }
        boolean access = false;
        try {
            Long memberid = perm.getMemberId();
            Member mem = null;
            if (memberid != null && (mem = DatabaseQuery.getMemberById((Database)db, (Long)memberid)) == null) {
                throw new DatabaseException("Member not found with ID: " + memberid);
            }
            access = (perm.getEditXLinks() || this.xl.getAuthorOnly() != false) && (mem != null && mem.equals((Object)this.xl.getMember()) || perm.matchExternalUserId(this.xl.getExternalUserId()));
        }
        catch (DatabaseException ex) {
            LoggerFactory.getLogger(EditXLinkCheck.class).error("Unable to perform check", (Throwable)ex);
        }
        return access;
    }
}

