/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class DeleteXLinkCheck
extends PermissionCheck {
    public DeleteXLinkCheck(@Nullable URI uri, @Nullable XLink xl) {
        this.uri = uri;
        this.xl = xl;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        boolean access = false;
        try {
            Long memberid = perm.getMemberId();
            Member mem = null;
            if (memberid != null && (mem = DatabaseQuery.getMemberById((Database)db, (Long)memberid)) == null) {
                throw new DatabaseException("Member not found with ID: " + memberid);
            }
            access = memberid != null && (perm.getDeleteAllXLinks() || perm.getDeleteXLinks() && (mem != null && this.xl.getMember() == mem || perm.matchExternalUserId(this.xl.getExternalUserId())));
        }
        catch (DatabaseException ex) {
            LoggerFactory.getLogger(DeleteXLinkCheck.class).error("Unable to perform check", (Throwable)ex);
        }
        return access;
    }
}

