/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.openid;

import com.pageseeder.base.oauth.jwt.JWTAlgorithm;
import com.pageseeder.base.oauth.jwt.JWTClaim;
import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.base.oauth.jwt.JWTException;
import com.pageseeder.base.oauth.jwt.JWTSigner;
import com.pageseeder.base.oauth.jwt.JWTVerifier;
import com.pageseeder.base.oauth.jwt.JWToken;

public final class IDToken
extends JWToken {
    public IDToken(String token) {
        super(token);
    }

    public JWTClaimSet toClaimSet(byte[] key) throws JWTException {
        JWTVerifier verifier = new JWTVerifier(key);
        return verifier.verify(this.token());
    }

    public static final class Builder {
        private final JWTClaimSet claims;
        private static final JWTClaim.Registered[] REQUIRED = new JWTClaim.Registered[]{JWTClaim.Registered.iss, JWTClaim.Registered.sub, JWTClaim.Registered.aud, JWTClaim.Registered.exp, JWTClaim.Registered.iat};

        public Builder() {
            this.claims = new JWTClaimSet();
        }

        public Builder(JWTClaimSet claims) {
            this.claims = claims;
        }

        public Builder iss(String issuer) {
            this.claims.add(new JWTClaim(JWTClaim.Registered.iss, issuer));
            return this;
        }

        public Builder sub(String subject) {
            this.claims.add(new JWTClaim(JWTClaim.Registered.sub, subject));
            return this;
        }

        public Builder aud(String audience) {
            this.claims.add(new JWTClaim(JWTClaim.Registered.aud, audience));
            return this;
        }

        public Builder exp(long expiration) {
            this.claims.add(new JWTClaim(JWTClaim.Registered.exp, expiration));
            return this;
        }

        public Builder iat(long issued) {
            this.claims.add(new JWTClaim(JWTClaim.Registered.iat, issued));
            return this;
        }

        public Builder authTime(long secondsSinceEpoch) {
            this.claims.add(new JWTClaim("auth_time", secondsSinceEpoch));
            return this;
        }

        public Builder nonce(String nonce) {
            this.claims.add(new JWTClaim("nonce", nonce));
            return this;
        }

        public Builder acr(String acr) {
            this.claims.add(new JWTClaim("acr", acr));
            return this;
        }

        public Builder amr(String amr) {
            this.claims.add(new JWTClaim("amr", amr));
            return this;
        }

        public Builder azp(String azp) {
            this.claims.add(new JWTClaim("azp", azp));
            return this;
        }

        public IDToken build(JWTAlgorithm algorithm, byte[] key) {
            if (!this.claims.has(JWTClaim.Registered.iat)) {
                this.claims.add(new JWTClaim(JWTClaim.Registered.iat, System.currentTimeMillis() / 1000L));
            }
            for (JWTClaim.Registered claim : REQUIRED) {
                if (this.claims.has(claim)) continue;
                throw new IllegalStateException(String.format("Missing required claim '%s'", claim.name()));
            }
            JWTSigner signer = new JWTSigner(key);
            return new IDToken(signer.sign(this.claims, algorithm));
        }
    }
}

