/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import java.util.Objects;

public class JWToken {
    private final String token;
    private final String[] segments;

    public JWToken(String token) {
        this.token = Objects.requireNonNull(token, "Token cannot be null");
        this.segments = token.split("\\.", -1);
        if (this.segments.length != 3) {
            throw new IllegalArgumentException("Invalid token");
        }
    }

    public final String token() {
        return this.token;
    }

    public final String header() {
        return this.segments[0];
    }

    public final String payload() {
        return this.segments[1];
    }

    public final String signature() {
        return this.segments[2];
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWToken other = (JWToken)obj;
        return Objects.equals(this.token, other.token);
    }

    public String toString() {
        return this.token;
    }
}

