/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import com.pageseeder.base.oauth.jwt.JWTClaim;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class JWTClaimSet {
    private final List<JWTClaim> claims = new ArrayList<JWTClaim>();

    public void add(JWTClaim claim) {
        Objects.requireNonNull(claim, "Cannot add null claim to set");
        int i = this.find(claim.name());
        if (i < 0) {
            this.claims.add(claim);
        } else {
            this.claims.set(i, claim);
        }
    }

    public void setIssuer(String issuer) {
        this.add(new JWTClaim(JWTClaim.Registered.iss, issuer));
    }

    public void setAudience(String audience) {
        this.add(new JWTClaim(JWTClaim.Registered.aud, audience));
    }

    public void setSubject(String subject) {
        this.add(new JWTClaim(JWTClaim.Registered.sub, subject));
    }

    public void addClaim(String name, String value) {
        this.add(JWTClaim.newJWTClaim(name, value));
    }

    public void setIssuedAtToNow() {
        long nowInMinutes = System.currentTimeMillis() / 1000L;
        this.add(new JWTClaim(JWTClaim.Registered.iat, nowInMinutes));
    }

    public boolean has(String claim) {
        return this.find(claim) != -1;
    }

    public boolean has(JWTClaim.Registered claim) {
        return this.find(claim.name()) != -1;
    }

    public void remove(String claim) {
        Objects.requireNonNull(claim, "Cannot remove null claim from set");
        int i = this.find(claim);
        if (i >= 0) {
            this.claims.remove(i);
        }
    }

    public List<JWTClaim> asList() {
        return Collections.unmodifiableList(this.claims);
    }

    public @Nullable JWTClaim get(String name) {
        for (JWTClaim claim : this.claims) {
            if (!claim.name().equals(name)) continue;
            return claim;
        }
        return null;
    }

    public @Nullable JWTClaim get(JWTClaim.Registered registered) {
        return this.get(registered.name());
    }

    public int size() {
        return this.claims.size();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (JWTClaim claim : this.claims) {
            map.put(claim.name(), claim.value());
        }
        return map;
    }

    public String toJSON() {
        StringWriter out = new StringWriter();
        try (JsonGenerator json = Json.createGenerator((Writer)out);){
            json.writeStartObject();
            for (JWTClaim claim : this.claims) {
                claim.writeJSON(json);
            }
            json.writeEnd();
            json.flush();
        }
        return out.toString();
    }

    public boolean hasExpired() {
        JWTClaim claim = this.get(JWTClaim.Registered.exp);
        if (claim == null) {
            return false;
        }
        return System.currentTimeMillis() / 1000L >= claim.longValue();
    }

    public boolean matchValue(JWTClaim.Registered registered, @Nullable String value) {
        JWTClaim claim = this.get(registered);
        if (claim == null || value == null) {
            return true;
        }
        return value.equals(claim.value());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTClaimSet that = (JWTClaimSet)o;
        return this.claims.equals(that.claims);
    }

    public int hashCode() {
        return this.claims.hashCode();
    }

    public static @Nullable JWTClaimSet parseJSON(String json) throws ParseException {
        JWTClaimSet set = null;
        try (JsonParser parser = Json.createParser((Reader)new StringReader(json));){
            try {
                String name = null;
                while (parser.hasNext()) {
                    JsonParser.Event event = parser.next();
                    if (event == JsonParser.Event.START_OBJECT) {
                        if (set != null) {
                            throw new ParseException("Unexpected new object in claim set", (int)parser.getLocation().getStreamOffset());
                        }
                        set = new JWTClaimSet();
                        continue;
                    }
                    if (event == JsonParser.Event.KEY_NAME) {
                        name = parser.getString();
                        continue;
                    }
                    if (set == null) continue;
                    assert (name != null);
                    if (event == JsonParser.Event.VALUE_STRING) {
                        set.add(new JWTClaim(name, parser.getString()));
                        continue;
                    }
                    if (event == JsonParser.Event.VALUE_NUMBER) {
                        set.add(new JWTClaim(name, parser.getLong()));
                        continue;
                    }
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        set.add(new JWTClaim(name, true));
                        continue;
                    }
                    if (event != JsonParser.Event.VALUE_FALSE) continue;
                    set.add(new JWTClaim(name, false));
                }
            }
            catch (Exception ex) {
                throw new ParseException("Unable to parse", (int)parser.getLocation().getStreamOffset());
            }
        }
        return set;
    }

    private int find(String name) {
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!this.claims.get(i).name().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

