/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import jakarta.json.stream.JsonGenerator;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class JWTClaim
implements Serializable {
    private static final long serialVersionUID = 8916286190266508070L;
    private final String name;
    private final Datatype datatype;
    private final Object value;

    public JWTClaim(Registered reg, String value) {
        Objects.requireNonNull(reg, "Registered claim is null");
        JWTClaim.checkValue(value, reg.getDatatype());
        this.name = reg.name();
        this.datatype = reg.getDatatype();
        this.value = JWTClaim.coerceValue(reg.getDatatype(), value);
    }

    public JWTClaim(Registered reg, long value) {
        Objects.requireNonNull(reg, "Registered claim is null");
        this.name = reg.name();
        this.datatype = reg.getDatatype();
        this.value = value;
    }

    public JWTClaim(String name, Datatype datatype, String value) {
        JWTClaim.checkName(name);
        JWTClaim.checkValue(value, datatype);
        this.name = name;
        this.datatype = datatype;
        this.value = JWTClaim.coerceValue(datatype, value);
    }

    public JWTClaim(String name, String value) {
        JWTClaim.checkName(name);
        JWTClaim.checkValue(value, Datatype.AnyString);
        this.name = name;
        this.datatype = Datatype.AnyString;
        this.value = value;
    }

    public JWTClaim(String name, long value) {
        JWTClaim.checkName(name);
        this.name = name;
        this.datatype = Datatype.NumericDate;
        this.value = value;
    }

    public JWTClaim(String name, boolean value) {
        JWTClaim.checkName(name);
        this.name = name;
        this.datatype = Datatype.Boolean;
        this.value = value;
    }

    public final String name() {
        return this.name;
    }

    public final Datatype datatype() {
        return this.datatype;
    }

    public final String value() {
        return this.value.toString();
    }

    public final long longValue() {
        if (!(this.value instanceof Long)) {
            throw new IllegalStateException(String.format("Cannot return long value: claim is '%s'", this.datatype().name()));
        }
        return (Long)this.value;
    }

    public final boolean booleanValue() {
        if (!(this.value instanceof Boolean)) {
            throw new IllegalStateException(String.format("Cannot return boolean value: claim is '%s'", this.datatype().name()));
        }
        return (Boolean)this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWTClaim other = (JWTClaim)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "JWTClaim:" + this.name + "=" + String.valueOf(this.value);
    }

    public static JWTClaim newJWTClaim(String name, String value) {
        JWTClaim.checkName(name);
        if (JWTClaim.isRegisteredName(name)) {
            Registered registered = Registered.valueOf(name);
            registered.getDatatype();
            return new JWTClaim(registered, value);
        }
        Datatype datatype = Datatype.AnyString;
        return new JWTClaim(name, datatype, value);
    }

    public static boolean isRegisteredName(String name) {
        for (Registered n : Registered.values()) {
            if (!n.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    void writeJSON(JsonGenerator json) {
        if (this.datatype == Datatype.Boolean) {
            json.write(this.name, this.booleanValue());
        } else if (this.datatype == Datatype.NumericDate) {
            json.write(this.name, this.longValue());
        } else {
            json.write(this.name, this.value.toString());
        }
    }

    private static void checkName(String name) {
        Objects.requireNonNull(name, "Claim is invalid: name is null");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Claim is invalid: value is empty");
        }
    }

    private static void checkValue(String value, Datatype datatype) {
        String message = datatype.checkValue(value);
        if (message != null) {
            throw new NullPointerException(message);
        }
    }

    private static Object coerceValue(Datatype datatype, String value) {
        switch (datatype) {
            case StringOrURI: 
            case AnyString: {
                return value;
            }
            case Boolean: {
                return Boolean.valueOf(value);
            }
            case NumericDate: {
                return Long.valueOf(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum Registered {
        iss(Datatype.StringOrURI),
        sub(Datatype.StringOrURI),
        aud(Datatype.StringOrURI),
        exp(Datatype.NumericDate),
        nbf(Datatype.NumericDate),
        iat(Datatype.NumericDate),
        jti(Datatype.AnyString);

        private final Datatype datatype;

        private Registered(Datatype datatype) {
            this.datatype = datatype;
        }

        public Datatype getDatatype() {
            return this.datatype;
        }
    }

    public static enum Datatype {
        StringOrURI{

            @Override
            public @Nullable String checkValue(@Nullable String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                if (value.contains(":")) {
                    try {
                        URI.create(value);
                    }
                    catch (IllegalArgumentException ex) {
                        return "Invalid claim value: not a valid URI";
                    }
                }
                return null;
            }
        }
        ,
        NumericDate{

            @Override
            public @Nullable String checkValue(@Nullable String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                try {
                    long n = Long.parseLong(value);
                    if (n <= 0L) {
                        return "Invalid claim value: negative number";
                    }
                }
                catch (NumberFormatException ex) {
                    return "Invalid claim value: not a number";
                }
                return null;
            }
        }
        ,
        Boolean{

            @Override
            public @Nullable String checkValue(@Nullable String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                if ("true".equals(value) || "false".equals(value)) {
                    return null;
                }
                return "Invalid claim value: not a boolean";
            }
        }
        ,
        AnyString{

            @Override
            public @Nullable String checkValue(@Nullable String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                return null;
            }
        };


        public abstract @Nullable String checkValue(@Nullable String var1);
    }
}

