/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.common.util.Strings;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.LoggerFactory;

public abstract class OAuthResponse {
    private static final String NO_STORE = "no-store";
    private final int status;
    protected Map<OAuthParameter, String> parameters = new EnumMap<OAuthParameter, String>(OAuthParameter.class);
    protected String location;
    protected String realm;

    protected OAuthResponse(int status) {
        this.status = status;
    }

    public OAuthResponse location(String location) {
        this.location = location;
        return this;
    }

    public OAuthResponse setScope(String value) {
        this.parameters.put(OAuthParameter.scope, value);
        return this;
    }

    protected OAuthResponse setParameter(OAuthParameter key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public void toQueryMessage(HttpServletResponse res) throws IOException {
        boolean hasAccessToken = this.parameters.containsKey((Object)OAuthParameter.access_token);
        String redirect = hasAccessToken ? OAuthResponse.computeFragmentRedirectURI(this.location, this.parameters) : OAuthResponse.computeQueryRedirectURI(this.location, this.parameters);
        res.setStatus(this.status);
        res.sendRedirect(redirect);
    }

    public void toBodyMessage(HttpServletResponse res) throws IOException {
        String body = OAuthResponse.toURLEncodedFormat(this.parameters);
        res.setStatus(this.status);
        res.setContentType("application/x-www-form-urlencoded");
        res.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (this.status == 401) {
            String header = OAuthResponse.encodeWWWAuthenticateHeader(this.realm, this.parameters);
            res.setHeader("WWW-Authenticate", OAuthResponse.toSafeHeader(header));
        }
        res.setHeader("Cache-Control", NO_STORE);
        PrintWriter w = res.getWriter();
        w.write(body);
        w.close();
    }

    public void toJSONMessage(HttpServletResponse res) {
        try {
            res.setStatus(this.status);
            res.setContentType("application/json; charset=utf-8");
            res.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (this.status == 401) {
                String header = OAuthResponse.encodeWWWAuthenticateHeader(this.realm, this.parameters);
                res.setHeader("WWW-Authenticate", OAuthResponse.toSafeHeader(header));
            }
            res.setHeader("Cache-Control", NO_STORE);
            PrintWriter w = res.getWriter();
            OAuthResponse.writeJSON(w, this.parameters);
            w.flush();
            w.close();
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(OAuthResponse.class).error("Unable to write JSON response", (Throwable)ex);
        }
    }

    private static @Nullable String toSafeHeader(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("[\\r\\n]", " ");
    }

    public void toXMLMessage(HttpServletResponse res) {
        try {
            res.setStatus(this.status);
            if (this.status == 401) {
                String header = OAuthResponse.encodeWWWAuthenticateHeader(this.realm, this.parameters);
                res.setHeader("WWW-Authenticate", OAuthResponse.toSafeHeader(header));
            }
            res.setContentType("application/xml; charset=utf-8");
            res.setCharacterEncoding(StandardCharsets.UTF_8.name());
            res.setHeader("Cache-Control", NO_STORE);
            PrintWriter w = res.getWriter();
            OAuthResponse.writeXML(w, this.parameters);
            w.flush();
            w.close();
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(OAuthResponse.class).error("Unable to write JSON response", (Throwable)ex);
        }
    }

    public static String encodeWWWAuthenticateHeader(String realm, Map<OAuthParameter, String> parameters) {
        StringBuilder out = new StringBuilder();
        out.append("Bearer ");
        if (!Strings.isEmpty((String)realm)) {
            out.append("realm=\"").append(realm).append("\",");
        }
        for (Map.Entry<OAuthParameter, String> entry : parameters.entrySet()) {
            String name = entry.getKey().name();
            String value = entry.getValue();
            if (Strings.isEmpty((String)value)) continue;
            out.append(name).append("=\"").append(value).append("\",");
        }
        return out.substring(0, out.length() - 1);
    }

    private static String computeFragmentRedirectURI(@Nullable String redirectURI, Map<OAuthParameter, String> parameters) {
        StringBuilder url = new StringBuilder();
        if (redirectURI != null) {
            url.append(redirectURI);
            parameters.remove((Object)OAuthParameter.refresh_token);
            String fragment = OAuthResponse.toURLEncodedFormat(parameters);
            if (!Strings.isEmpty((String)fragment) && !parameters.isEmpty()) {
                url.append("#").append(fragment);
            }
        }
        return url.toString();
    }

    private static String computeQueryRedirectURI(@Nullable String redirectURI, Map<OAuthParameter, String> parameters) {
        StringBuilder url = new StringBuilder();
        if (redirectURI != null) {
            url.append(redirectURI);
            boolean containsQuestionMark = redirectURI.contains("?");
            String query = OAuthResponse.toURLEncodedFormat(parameters);
            if (!Strings.isEmpty((String)query)) {
                if (containsQuestionMark) {
                    url.append("&").append(query);
                } else {
                    url.append("?").append(query);
                }
            }
        }
        return url.toString();
    }

    private static String toURLEncodedFormat(Map<OAuthParameter, String> parameters) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<OAuthParameter, String> parameter : parameters.entrySet()) {
            String name = parameter.getKey().name();
            String value = parameter.getValue();
            if (Strings.isEmpty((String)value)) continue;
            String encodedName = OAuthResponse.encode(name);
            String encodedValue = OAuthResponse.encode(value);
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(encodedName).append('=').append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content) {
        return URLEncoder.encode(content, StandardCharsets.UTF_8);
    }

    private static void writeJSON(PrintWriter writer, Map<OAuthParameter, String> parameters) {
        try (JsonGenerator generator = Json.createGenerator((Writer)writer);){
            generator.writeStartObject();
            for (Map.Entry<OAuthParameter, String> p : parameters.entrySet()) {
                OAuthParameter name = p.getKey();
                String value = p.getValue();
                if (Strings.isEmpty((String)value)) continue;
                if (name == OAuthParameter.expires_in) {
                    generator.write(name.name(), Long.parseLong(value));
                    continue;
                }
                generator.write(name.name(), value);
            }
            generator.writeEnd();
            generator.flush();
        }
    }

    private static void writeXML(PrintWriter writer, Map<OAuthParameter, String> parameters) throws IOException {
        XMLWriterImpl xml = new XMLWriterImpl((Writer)writer);
        xml.openElement("oauth");
        for (Map.Entry<OAuthParameter, String> p : parameters.entrySet()) {
            String name = p.getKey().name();
            String value = p.getValue();
            if (Strings.isEmpty((String)value)) continue;
            xml.attribute(name, value);
        }
        xml.closeElement();
        xml.flush();
    }
}

