/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.webauthn;

import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.webauthn.PSCredentialRepository;
import com.pageseeder.base.mfa.webauthn.PublicKeyCreation;
import com.pageseeder.base.mfa.webauthn.PublicKeyRequest;
import com.pageseeder.base.mfa.webauthn.WebAuthn;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.data.UserVerificationRequirement;
import com.yubico.webauthn.exception.AssertionFailedException;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnManager
implements ChallengeIssuer,
ChallengeVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnManager.class);
    private static final int TTL_MINUTES = 6;
    private final RelyingParty rp;
    private Database db;

    public WebAuthnManager(Database db) {
        RelyingPartyIdentity rpIdentity = WebAuthn.getRelyingPartyIdentity();
        PSCredentialRepository credentialRepository = new PSCredentialRepository(db);
        this.rp = RelyingParty.builder().identity(rpIdentity).credentialRepository((CredentialRepository)credentialRepository).origins(WebAuthn.getOrigins()).attestationConveyancePreference(Optional.of(AttestationConveyancePreference.DIRECT)).allowOriginPort(true).allowOriginSubdomain(false).allowUntrustedAttestation(true).validateSignatureCounter(true).build();
        this.db = db;
    }

    @Override
    public ChallengeRequest issueChallenge(Authenticator authenticator, Member member) {
        if (authenticator.isVerified()) {
            return this.sendAuthenticationChallenge(authenticator, member);
        }
        return this.sendRegistrationChallenge(authenticator, member);
    }

    public ChallengeRequest sendRegistrationChallenge(Authenticator authenticator, Member member) {
        Challenge challenge;
        LOGGER.debug("Preparing registration challenge for {} ({}) with {}", new Object[]{member.getUsername(), member.getId(), authenticator});
        try {
            ResidentKeyRequirement residentKeyRequirement = ResidentKeyRequirement.DISCOURAGED;
            AuthenticatorAttachment attachment = WebAuthn.getAttachment(authenticator);
            UserVerificationRequirement userVerification = UserVerificationRequirement.PREFERRED;
            AuthenticatorSelectionCriteria criteria = AuthenticatorSelectionCriteria.builder().authenticatorAttachment(attachment).residentKey(residentKeyRequirement).userVerification(userVerification).build();
            UserIdentity registrationUserId = WebAuthn.toUserIdentity(member);
            PublicKeyCredentialCreationOptions options = this.rp.startRegistration(StartRegistrationOptions.builder().user(registrationUserId).authenticatorSelection(criteria).timeout(360000L).build());
            String[] hints = WebAuthn.getHints(authenticator);
            PublicKeyCreation data = new PublicKeyCreation(options, hints);
            challenge = ChallengeManager.singleton().newChallenge(authenticator, 6, data);
            LOGGER.debug("Sending registration challenge {} for {} ({})", new Object[]{challenge.getId(), member.getUsername(), member.getId()});
        }
        catch (Exception ex) {
            LOGGER.error("Unable to create challenge: {}", (Object)ex.getMessage(), (Object)ex);
            return ChallengeRequest.error();
        }
        return ChallengeRequest.publicKey(challenge);
    }

    public ChallengeRequest sendAuthenticationChallenge(Authenticator authenticator, Member member) {
        Challenge challenge;
        LOGGER.debug("Preparing authentication challenge for {} ({}) with {}", new Object[]{member.getUsername(), member.getId(), authenticator});
        try {
            String username = member.getUsername();
            AssertionRequest assertionRequest = this.rp.startAssertion(StartAssertionOptions.builder().username(username).timeout(360000L).build());
            PublicKeyRequest data = new PublicKeyRequest(assertionRequest.getPublicKeyCredentialRequestOptions());
            challenge = ChallengeManager.singleton().newChallenge(authenticator, 6, data);
            LOGGER.debug("Sending authentication challenge {} for {} ({})", new Object[]{challenge.getId(), member.getUsername(), member.getId()});
        }
        catch (Exception ex) {
            LOGGER.error("Unable to create authentication challenge: {}", (Object)ex.getMessage(), (Object)ex);
            return ChallengeRequest.error();
        }
        return ChallengeRequest.publicKey(challenge);
    }

    @Override
    public ChallengeResult verifyChallenge(Authenticator authenticator, Challenge challenge, String credentialJson) {
        if (authenticator.isVerified()) {
            return this.verifyAuthentication(authenticator, challenge, credentialJson);
        }
        return this.verifyRegistration(authenticator, challenge, credentialJson);
    }

    public ChallengeResult verifyRegistration(Authenticator authenticator, Challenge challenge, String credentialJson) {
        LOGGER.debug("Verifying registration challenge {} with {} for {}", new Object[]{challenge.getId(), authenticator, authenticator.getMemberId()});
        ChallengeManager manager = ChallengeManager.singleton();
        PublicKeyCreation data = (PublicKeyCreation)challenge.getData();
        if (data == null) {
            return ChallengeResult.INVALID_CHALLENGE;
        }
        PublicKeyCredentialCreationOptions options = data.getPublicKeyCredentialCreationOptions();
        try {
            PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> credential = WebAuthn.parseRegistrationResponseJson(credentialJson);
            RegistrationResult result = this.rp.finishRegistration(FinishRegistrationOptions.builder().request(options).response(credential).build());
            long memberId = WebAuthn.toMemberId(data.getPublicKeyCredentialCreationOptions().getUser().getId());
            if (memberId != authenticator.getMemberId()) {
                return ChallengeResult.INVALID_CHALLENGE;
            }
            UserIdentity userIdentity = options.getUser();
            manager.invalidate(challenge.getId());
            ByteArray credentialId = result.getKeyId().getId();
            RegisteredCredential registeredCredential = RegisteredCredential.builder().credentialId(credentialId).userHandle(userIdentity.getId()).publicKeyCose(result.getPublicKeyCose()).signatureCount(result.getSignatureCount()).build();
            PublicKeyCredentialDescriptor descriptor = result.getKeyId();
            WebAuthn.setCredentialId(authenticator, credentialId);
            WebAuthn.setTransports(authenticator, descriptor.getTransports().orElse(null));
            authenticator.setPublicKey(registeredCredential.getPublicKeyCose().getBytes());
            authenticator.setSignCount(Long.valueOf(result.getSignatureCount()));
            authenticator.setName(WebAuthn.toName(credential));
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to verify challenge: {}", (Object)challenge.getId(), (Object)ex);
            return ChallengeResult.ERROR;
        }
        return ChallengeResult.SUCCESS;
    }

    public ChallengeResult verifyAuthentication(Authenticator authenticator, Challenge challenge, String credentialJson) {
        LOGGER.debug("Verifying authentication challenge {} with {} for {}", new Object[]{challenge.getId(), authenticator, authenticator.getMemberId()});
        ChallengeManager manager = ChallengeManager.singleton();
        PublicKeyRequest data = (PublicKeyRequest)challenge.getData();
        if (data == null) {
            return ChallengeResult.INVALID_CHALLENGE;
        }
        PublicKeyCredentialRequestOptions options = data.getPublicKeyCredentialRequestOptions();
        try {
            PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> credential = WebAuthn.parseAssertionResponseJson(credentialJson);
            AssertionRequest request = AssertionRequest.builder().publicKeyCredentialRequestOptions(options).userHandle(WebAuthn.toHandle(authenticator.getMemberId())).build();
            AssertionResult result = this.rp.finishAssertion(FinishAssertionOptions.builder().request(request).response(credential).build());
            AuthenticatorData authenticatorData = ((AuthenticatorAssertionResponse)credential.getResponse()).getParsedAuthenticatorData();
            manager.invalidate(challenge.getId());
            if (!result.isSuccess()) {
                return ChallengeResult.FAILURE;
            }
            this.updateSignatureCount(result);
            authenticator.setSignCount(Long.valueOf(result.getSignatureCount()));
        }
        catch (AssertionFailedException ex) {
            LOGGER.warn("Failed to verify challenge: {} due to {}", (Object)challenge.getId(), (Object)ex.getMessage());
            return ChallengeResult.ERROR;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to verify challenge: {}", (Object)challenge.getId(), (Object)ex);
            return ChallengeResult.ERROR;
        }
        return ChallengeResult.SUCCESS;
    }

    private void updateSignatureCount(AssertionResult result) {
        try {
            RegisteredCredential rc = result.getCredential();
            String username = result.getUsername();
            CredentialRepository repo = this.rp.getCredentialRepository();
            ByteArray handle = (ByteArray)repo.getUserHandleForUsername(username).get();
            long memberId = WebAuthn.toMemberId(handle);
            Authenticator auth = Authenticators.getVerifiedAuthenticatorForMemberCredentialId((Database)this.db, (long)memberId, (byte[])rc.getCredentialId().getBytes());
            LOGGER.error("Found: {}", (Object)auth);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to update signature count: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

