/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.webauthn;

import com.pageseeder.base.mfa.webauthn.InvalidPKCResponseException;
import com.pageseeder.base.mfa.webauthn.UnavailableCryptoException;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.KeyStorage;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebAuthn {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthn.class);
    private static final String KEY_ALIAS = "webauthn-id";
    private static final int HANDLE_LENGTH = 16;
    private static @Nullable IvParameterSpec cachedIv = null;

    private WebAuthn() {
    }

    public static RelyingPartyIdentity getRelyingPartyIdentity() {
        return RelyingPartyIdentity.builder().id(GlobalSettings.get((String)"webSiteAddress")).name("PageSeeder").build();
    }

    public static Set<String> getOrigins() {
        String scheme = Settings.getServerScheme();
        int port = Settings.getServerPort();
        String host = GlobalSettings.get((String)"webSiteAddress");
        return Collections.singleton(scheme + "://" + host + ":" + port);
    }

    public static UserIdentity toUserIdentity(Member member) throws UnavailableCryptoException {
        return new UserIdentity.UserIdentityBuilder.MandatoryStages().name(member.getUsername()).displayName(MemberRule.getFullName(member)).id(WebAuthn.toHandle(member.getId())).build();
    }

    public static PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> parseRegistrationResponseJson(String credentialJson) throws InvalidPKCResponseException {
        try {
            return PublicKeyCredential.parseRegistrationResponseJson((String)credentialJson);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to parse JSON for PublicKeyCredential registration", (Throwable)ex);
            throw new InvalidPKCResponseException("Unable to parse JSON for PublicKeyCredential registration");
        }
    }

    public static PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> parseAssertionResponseJson(String credentialJson) throws InvalidPKCResponseException {
        try {
            return PublicKeyCredential.parseAssertionResponseJson((String)credentialJson);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to parse JSON for PublicKeyCredential assertion", (Throwable)ex);
            throw new InvalidPKCResponseException("Unable to parse JSON for PublicKeyCredential assertion");
        }
    }

    public static ByteArray getCredentialId(Authenticator authenticator) {
        return new ByteArray(authenticator.getCredentialId() != null ? authenticator.getCredentialId() : new byte[]{});
    }

    public static void setCredentialId(Authenticator authenticator, ByteArray credentialId) {
        authenticator.setCredentialId(credentialId.getBytes());
    }

    public static Set<AuthenticatorTransport> getTransports(Authenticator authenticator) {
        String rawValue = authenticator.getParameter("transports");
        if (rawValue == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(Strings.split((String)rawValue, (char)',')).filter(t -> !t.isEmpty()).map(AuthenticatorTransport::of).collect(Collectors.toSet());
    }

    public static String[] getHints(Authenticator authenticator) {
        String hints = authenticator.getParameter("hints");
        if (hints == null || hints.isEmpty()) {
            return new String[0];
        }
        return hints.split(",");
    }

    public static @Nullable AuthenticatorAttachment getAttachment(Authenticator authenticator) {
        String rawValue = authenticator.getParameter("attachment");
        if (rawValue == null) {
            return null;
        }
        for (AuthenticatorAttachment attachment : AuthenticatorAttachment.values()) {
            if (!attachment.getValue().equals(rawValue)) continue;
            return attachment;
        }
        return null;
    }

    public static void setTransports(Authenticator authenticator, @Nullable Set<AuthenticatorTransport> transports) {
        if (transports == null) {
            return;
        }
        String value = transports.stream().map(AuthenticatorTransport::getId).collect(Collectors.joining(","));
        authenticator.putParameter("transports", value);
    }

    public static String toName(PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> credential) {
        SortedSet transports = ((AuthenticatorAttestationResponse)credential.getResponse()).getTransports();
        if (transports == null) {
            return "Webauthn authenticator";
        }
        if (transports.contains(AuthenticatorTransport.USB)) {
            return "USB security key";
        }
        if (transports.contains(AuthenticatorTransport.NFC)) {
            return "NFC-enabled security key";
        }
        if (transports.contains(AuthenticatorTransport.BLE)) {
            return "Bluetooth-enabled authenticator";
        }
        if (transports.contains(AuthenticatorTransport.INTERNAL)) {
            AuthenticatorAttachment attachment = credential.getAuthenticatorAttachment().orElse(null);
            if (attachment == AuthenticatorAttachment.PLATFORM) {
                return "Built-in device authenticator";
            }
            if (attachment == AuthenticatorAttachment.CROSS_PLATFORM) {
                return "External device authenticator";
            }
            return "Internal device authenticator";
        }
        return "Unknown authenticator";
    }

    public static ByteArray toHandle(long memberId) throws UnavailableCryptoException {
        try {
            byte[] bytes = WebAuthn.longToBytes(memberId);
            byte[] encrypted = WebAuthn.getCipher(1).doFinal(bytes);
            return new ByteArray(encrypted);
        }
        catch (GeneralSecurityException ex) {
            throw new UnavailableCryptoException("Unable to generate handle for member", ex);
        }
    }

    public static long toMemberId(ByteArray handle) throws UnavailableCryptoException {
        if (handle.size() != 16) {
            return -1L;
        }
        try {
            Cipher cipher = WebAuthn.getCipher(2);
            byte[] decrypted = cipher.doFinal(handle.getBytes());
            return WebAuthn.bytesToLong(decrypted);
        }
        catch (GeneralSecurityException ex) {
            throw new UnavailableCryptoException("Unable retrieve member ID from handle", ex);
        }
    }

    private static Cipher getCipher(int mode) throws GeneralSecurityException {
        SecretKey key = KeyStorage.getInstance().getSecretKey(KEY_ALIAS, KeyStorage.KeyType.AES);
        IvParameterSpec iv = WebAuthn.getCachedIv();
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(mode, (Key)key, iv);
        return cipher;
    }

    private static IvParameterSpec getCachedIv() throws NoSuchAlgorithmException {
        IvParameterSpec localIv = cachedIv;
        if (localIv == null) {
            cachedIv = localIv = WebAuthn.generateIv();
        }
        return localIv;
    }

    private static IvParameterSpec generateIv() throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] text = GlobalSettings.getString((String)"webSiteAddress", (String)"localhost").getBytes(StandardCharsets.UTF_8);
        md.update(text, 0, text.length);
        byte[] keyBytes = md.digest();
        return new IvParameterSpec(keyBytes, 0, 16);
    }

    static byte[] longToBytes(long value) {
        return ByteBuffer.allocate(16).putLong(0L).putLong(value).array();
    }

    static long bytesToLong(byte[] bytes) {
        if (bytes.length != 16) {
            return -1L;
        }
        long first = ByteBuffer.wrap(bytes, 0, 8).getLong();
        long last = ByteBuffer.wrap(bytes, 8, 8).getLong();
        return first == 0L ? last : -1L;
    }
}

