/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.webauthn;

import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.serial.OutputPrinter;
import com.yubico.webauthn.data.AssertionExtensionInputs;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.util.Objects;

public final class PublicKeyRequest
implements ChallengeData {
    private final PublicKeyCredentialRequestOptions options;

    public PublicKeyRequest(PublicKeyCredentialRequestOptions options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.options;
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("request-options");
        out.field("challenge", this.options.getChallenge().getBase64Url());
        out.field("rpId", this.options.getRpId());
        this.options.getTimeout().ifPresent(timeout -> out.field("timeout", (long)timeout));
        this.options.getUserVerification().ifPresent(userVerification -> out.field("userVerification", userVerification.getValue()));
        this.options.getAllowCredentials().ifPresent(allowCredentials -> {
            out.startCollection("allowCredentials");
            for (PublicKeyCredentialDescriptor descriptor : allowCredentials) {
                out.startObject("descriptor");
                out.field("id", descriptor.getId().getBase64Url());
                out.field("type", descriptor.getType().getId());
                descriptor.getTransports().ifPresent(transports -> {
                    String[] transportIds = (String[])transports.stream().map(AuthenticatorTransport::getId).toArray(String[]::new);
                    out.field("transports", transportIds);
                });
                out.endObject();
            }
            out.endCollection();
        });
        AssertionExtensionInputs extensions = this.options.getExtensions();
        out.startObject("extensions");
        extensions.getAppid().ifPresent(appId -> out.field("appId", appId.getId()));
        if (extensions.getUvm()) {
            out.field("uvm", true);
        }
        out.endObject();
        out.endObject();
    }
}

