/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.totp;

import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.security.HOTPGenerator;
import com.pageseeder.base.security.TOTPGenerator;
import com.pageseeder.db.model.Authenticator;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base32;
import org.slf4j.LoggerFactory;

public final class TOTP {
    public static final int DEFAULT_DIGITS = 6;
    public static final String DIGITS_PARAMETER = "digits";
    public static final String ALGORITHM_PARAMETER = "algorithm";
    private static final String BASE32_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final SecureRandom RANDOM = new SecureRandom();

    private TOTP() {
    }

    public static String newSecret(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(BASE32_ALPHABET.charAt(RANDOM.nextInt(BASE32_ALPHABET.length())));
        }
        return sb.toString();
    }

    public static String newSecret() {
        return TOTP.newSecret(24);
    }

    public static boolean isValidCodeLength(int digits) {
        return digits >= 6 && digits <= 8;
    }

    public static void setParameters(Authenticator authenticator, int digits, String algorithm) {
        authenticator.setParameters("digits=" + digits + ";algorithm=" + algorithm);
    }

    public static int getDigits(Authenticator authenticator) {
        String digits = authenticator.getParameter(DIGITS_PARAMETER);
        if (digits == null) {
            return 6;
        }
        try {
            return Integer.parseInt(digits);
        }
        catch (NumberFormatException ex) {
            return 6;
        }
    }

    public static String getAlgorithm(Authenticator authenticator) {
        String algorithm = authenticator.getParameter(ALGORITHM_PARAMETER);
        return algorithm != null ? algorithm : "SHA1";
    }

    public static String getSecret(Authenticator authenticator) {
        String secret = ConfidentialData.getData(authenticator);
        if (secret == null) {
            LoggerFactory.getLogger(TOTP.class).warn("Secret not found for authenticator {}", (Object)authenticator.getPublicId());
            secret = TOTP.newSecret();
            ConfidentialData.setData(authenticator, secret);
        }
        return secret;
    }

    public static String getAuthenticatorOTPAuthURL(Authenticator authenticator, String account, String issuer) {
        String secret = TOTP.getSecret(authenticator);
        int digits = TOTP.getDigits(authenticator);
        String algorithm = TOTP.getAlgorithm(authenticator).toUpperCase();
        return "otpauth://totp/" + URLEncoder.encode("PageSeeder:" + account, StandardCharsets.UTF_8).replace("+", "%20") + "?secret=" + URLEncoder.encode(secret, StandardCharsets.UTF_8).replace("+", "%20") + "&issuer=" + URLEncoder.encode(issuer, StandardCharsets.UTF_8).replace("+", "%20") + "&digits=" + digits + "&algorithm=" + algorithm + "&period=30";
    }

    public static boolean isValidAlgorithm(String algorithm) {
        return "SHA1".equalsIgnoreCase(algorithm) || "SHA256".equalsIgnoreCase(algorithm) || "SHA512".equalsIgnoreCase(algorithm);
    }

    public static String getCode(String secret, Instant time, String algorithm, int length) throws InvalidKeyException {
        byte[] secretBytes = Base32.decode((String)secret);
        SecretKeySpec signKey = new SecretKeySpec(secretBytes, "HmacSHA1");
        TOTPGenerator generator = new TOTPGenerator(TOTPGenerator.DEFAULT_TIME_STEP, HOTPGenerator.CodeLength.forLength(length), "Hmac" + algorithm.toUpperCase());
        return generator.generateOneTimePasswordString(signKey, time);
    }

    public static ChallengeResult checkCode(String secret, String code, String algorithm, int window) {
        if (!TOTP.isValidCodeLength(code.length())) {
            return ChallengeResult.INVALID_CHALLENGE;
        }
        Instant now = Instant.now();
        try {
            for (int i = -window; i <= window; ++i) {
                Instant time = now.plus((long)i * TOTPGenerator.DEFAULT_TIME_STEP.toSeconds(), ChronoUnit.SECONDS);
                String expected = TOTP.getCode(secret, time, algorithm, code.length());
                if (!expected.equals(code)) continue;
                return ChallengeResult.SUCCESS;
            }
        }
        catch (InvalidKeyException ex) {
            LoggerFactory.getLogger(TOTP.class).error("Invalid secret key for authenticator", (Throwable)ex);
            return ChallengeResult.ERROR;
        }
        return ChallengeResult.FAILURE;
    }
}

