/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.sms;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.base.mfa.core.VerificationCode;
import com.pageseeder.base.mfa.sms.InvalidPhoneNumber;
import com.pageseeder.base.mfa.sms.PhoneNumber;
import com.pageseeder.base.mfa.sms.SMSProvider;
import com.pageseeder.base.mfa.sms.SMSProviderException;
import com.pageseeder.db.model.Authenticator;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.pageseeder.berlioz.furi.Parameters;
import org.pageseeder.berlioz.furi.URIParameters;
import org.pageseeder.berlioz.furi.URITemplate;
import org.slf4j.LoggerFactory;

public final class TwilioVerify
implements SMSProvider {
    private static final String BASE_API = "https://verify.twilio.com/v2/Services";
    private static final String SEND_API = "https://verify.twilio.com/v2/Services/{ServiceId}/Verifications";
    private static final String VERIFY_API = "https://verify.twilio.com/v2/Services/{ServiceId}/VerificationCheck";
    private final String apiKey;
    private final String apiSecret;
    private final String sendApiUrl;
    private final String verifyApiUrl;

    TwilioVerify(String apiKey, String apiSecret, String serviceId) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        URIParameters parameters = new URIParameters();
        parameters.set("ServiceId", serviceId);
        this.sendApiUrl = URITemplate.expand((String)SEND_API, (Parameters)parameters);
        this.verifyApiUrl = URITemplate.expand((String)VERIFY_API, (Parameters)parameters);
    }

    @Override
    public String getName() {
        return "twilio-verify";
    }

    @Override
    public boolean sendCode(PhoneNumber to, String code) throws SMSProviderException {
        boolean created;
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.sendApiUrl)).header("Authorization", this.basicAuthorizationHeader()).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("To=" + URLEncoder.encode(to.toString(), StandardCharsets.UTF_8) + "&Channel=sms")).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            created = response.statusCode() == 201;
        }
        catch (IOException | InterruptedException ex) {
            throw new SMSProviderException(ex);
        }
        return created;
    }

    public boolean verifyCode(PhoneNumber to, String code) throws SMSProviderException {
        boolean verified;
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.verifyApiUrl)).header("Authorization", this.basicAuthorizationHeader()).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("To=" + URLEncoder.encode(to.toString(), StandardCharsets.UTF_8) + "&Code=" + URLEncoder.encode(code, StandardCharsets.UTF_8))).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            verified = response.statusCode() == 200;
        }
        catch (IOException | InterruptedException ex) {
            throw new SMSProviderException(ex);
        }
        return verified;
    }

    @Override
    public ChallengeRequest sendCode(Authenticator authenticator) {
        try {
            PhoneNumber phone = PhoneNumber.fromAuthenticator(authenticator);
            VerificationCode code = VerificationCode.newCode(6, VerificationCode.CodeType.DIGITS_ONLY);
            boolean sent = this.sendCode(phone, code.code());
            Challenge challenge = ChallengeManager.singleton().newChallenge(authenticator, 10, code);
            return sent ? ChallengeRequest.smsSent(challenge) : ChallengeRequest.error();
        }
        catch (MaxCapacityException | InvalidPhoneNumber | SMSProviderException ex) {
            LoggerFactory.getLogger(TwilioVerify.class).error("Unable to send the code due to {}", (Object)ex.getMessage(), (Object)ex);
            SecurityLog.error(authenticator.isVerified() ? SecurityLog.EventType.AUTHENTICATION : SecurityLog.EventType.ACCOUNT_CHANGE, "Unable to send code by SMS to {} due to {}", authenticator, ex.getMessage());
            return ChallengeRequest.error();
        }
    }

    @Override
    public ChallengeResult verifyChallenge(Authenticator authenticator, String challengeId, String code) {
        try {
            PhoneNumber phone = PhoneNumber.fromAuthenticator(authenticator);
            boolean sent = this.verifyCode(phone, code);
            return sent ? ChallengeResult.SUCCESS : ChallengeResult.FAILURE;
        }
        catch (InvalidPhoneNumber | SMSProviderException ex) {
            LoggerFactory.getLogger(TwilioVerify.class).error("Unable to verify the code due to {}", (Object)ex.getMessage());
            return ChallengeResult.ERROR;
        }
    }

    private String basicAuthorizationHeader() {
        String credentials = this.apiKey + ":" + this.apiSecret;
        return "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
    }
}

