/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.base.mfa.core.VerificationCode;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailOTP
implements ChallengeIssuer,
ChallengeVerifier {
    public static final Logger LOGGER = LoggerFactory.getLogger(EmailOTP.class);
    public static final int DEFAULT_TTL_MINUTES = 10;
    private final Database db;
    private final @Nullable Group group;

    public EmailOTP(Database db) {
        this.db = db;
        this.group = null;
    }

    public EmailOTP(Database db, Group group) {
        this.db = db;
        this.group = group;
    }

    @Override
    public ChallengeRequest issueChallenge(Authenticator authenticator, Member member) {
        try {
            String email = ConfidentialData.getData(authenticator);
            ChallengeManager manager = ChallengeManager.singleton();
            if (manager.hasReachedRateLimit(authenticator)) {
                return ChallengeRequest.rateLimitReached();
            }
            VerificationCode code = VerificationCode.newCode(6, VerificationCode.CodeType.ALPHA_NUMERIC);
            boolean async = GlobalSettings.getBoolean((String)"smtpAsync", (boolean)false);
            Emails.sendVerificationCodeEmail(this.db, this.group, member, email, code, async);
            Challenge challenge = manager.newChallenge(authenticator, 10, code);
            return ChallengeRequest.emailSent(challenge);
        }
        catch (FoundationException | MaxCapacityException | DatabaseException ex) {
            LOGGER.error("Unable to send code for authenticator: {}", (Object)authenticator.getPublicId(), (Object)ex);
            return ChallengeRequest.error();
        }
    }

    @Override
    public ChallengeResult verifyChallenge(Authenticator authenticator, Challenge challenge, String code) {
        if (challenge.matchCode(code)) {
            ChallengeManager.singleton().invalidate(challenge.getId());
            return ChallengeResult.SUCCESS;
        }
        return ChallengeResult.FAILURE;
    }
}

