/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.db.model.Authenticator;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public final class ChallengeManager {
    private static final ChallengeManager SINGLETON = new ChallengeManager();
    private static final int MAX_CAPACITY = 10000;
    private static final long PURGE_FREQUENCY_MINUTES = 5L;
    private static final char[] ID_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int MAX_CHALLENGES_PER_AUTHENTICATOR = 5;
    private final Map<String, Challenge> challenges;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    private ChallengeManager() {
        this.challenges = Collections.synchronizedMap(new LinkedHashMap());
        this.scheduler.scheduleAtFixedRate(new Scavenger(this), 10L, 5L, TimeUnit.MINUTES);
    }

    public static ChallengeManager singleton() {
        return SINGLETON;
    }

    public Challenge newChallenge(Authenticator authenticator, int ttlMinutes, ChallengeData data) throws MaxCapacityException {
        if (this.challenges.size() >= 10000) {
            throw new MaxCapacityException("Unable to store additional verification codes");
        }
        Challenge.Purpose purpose = authenticator.isVerified() ? Challenge.Purpose.AUTHENTICATION : Challenge.Purpose.REGISTRATION;
        Challenge challenge = new Challenge(this.newChallengeId(), purpose, authenticator.getPublicId(), ttlMinutes, data);
        this.challenges.put(challenge.getId(), challenge);
        return challenge;
    }

    private String newChallengeId() {
        String challengeId = this.generateRandomId();
        while (this.challenges.get(challengeId) != null) {
            challengeId = this.generateRandomId();
        }
        return challengeId;
    }

    private String generateRandomId() {
        return Passwords.random((int)16, (char[])ID_CHARACTERS);
    }

    public @Nullable Challenge get(String id) {
        Challenge challenge = this.challenges.get(id);
        if (challenge == null) {
            return null;
        }
        if (challenge.hasExpired()) {
            this.challenges.remove(id);
            return null;
        }
        return challenge;
    }

    public void invalidate(String id) {
        this.challenges.remove(id);
    }

    public int size() {
        return this.challenges.size();
    }

    public Collection<Challenge> getChallenges() {
        return Collections.unmodifiableCollection(this.challenges.values());
    }

    public boolean hasReachedRateLimit(Authenticator authenticator) {
        List<Challenge> list = this.listChallengesForAuthenticator(authenticator.getPublicId());
        if (list.size() > 5) {
            return true;
        }
        Instant oneMinuteAgo = Instant.now().minusSeconds(60L);
        return list.stream().anyMatch(challenge -> challenge.issuedAfter(oneMinuteAgo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Challenge> listChallengesForAuthenticator(String authenticator) {
        Map<String, Challenge> map = this.challenges;
        synchronized (map) {
            return this.challenges.values().stream().filter(challenge -> challenge.getAuthenticator().equals(authenticator) && !challenge.hasExpired()).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Challenge getCurrentForAuthenticator(String authenticator) {
        Instant oneMinuteAgo = Instant.now().minusSeconds(60L);
        Map<String, Challenge> map = this.challenges;
        synchronized (map) {
            return this.challenges.values().stream().filter(challenge -> challenge.getAuthenticator().equals(authenticator) && challenge.issuedAfter(oneMinuteAgo) && !challenge.hasExpired()).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeForAuthenticator(String authenticator) {
        Map<String, Challenge> map = this.challenges;
        synchronized (map) {
            this.challenges.entrySet().removeIf(e -> ((Challenge)e.getValue()).getAuthenticator().equals(authenticator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Instant now = Instant.now();
        Map<String, Challenge> map = this.challenges;
        synchronized (map) {
            this.challenges.entrySet().removeIf(e -> ((Challenge)e.getValue()).hasExpiredAt(now));
        }
    }

    public int clear() {
        int count = this.challenges.size();
        this.challenges.clear();
        return count;
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    private static class Scavenger
    implements Runnable {
        private final ChallengeManager manager;

        Scavenger(ChallengeManager manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            this.manager.purge();
        }
    }
}

