/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.mfa.core.VerificationCode;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.db.model.Authenticator;
import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class Challenge
implements Serializable,
UniversallyPrintable {
    private static final long serialVersionUID = 20241129L;
    private static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private final String id;
    private final String authenticator;
    private final OffsetDateTime issued;
    private final Purpose purpose;
    private final int ttlMinutes;
    private final @Nullable ChallengeData data;

    Challenge(String id, Purpose purpose, String authenticatorId, int ttlMinutes, @Nullable ChallengeData data) {
        this.id = id;
        this.purpose = purpose;
        this.authenticator = Objects.requireNonNull(authenticatorId);
        this.issued = OffsetDateTime.now();
        this.ttlMinutes = ttlMinutes;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public boolean matchAuthenticator(Authenticator authenticator) {
        return authenticator.getPublicId().equals(this.authenticator);
    }

    public boolean matchCode(String code) {
        if (this.data instanceof VerificationCode) {
            return ((VerificationCode)this.data).code().equals(code);
        }
        return false;
    }

    public Purpose getPurpose() {
        return this.purpose;
    }

    public @Nullable ChallengeData getData() {
        return this.data;
    }

    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public OffsetDateTime expires() {
        return this.issued.plusMinutes(this.ttlMinutes);
    }

    public boolean hasExpired() {
        return this.expires().toInstant().isBefore(Instant.now());
    }

    public boolean hasExpiredAt(Instant instant) {
        return this.expires().toInstant().isBefore(instant);
    }

    public boolean issuedAfter(Instant instant) {
        return this.issued.toInstant().isAfter(instant);
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("challenge");
        out.field("id", this.id);
        out.field("purpose", this.purpose.name().toLowerCase());
        out.field("authenticator", this.authenticator);
        out.field("issued", this.issued.format(ISO8601_DATETIME));
        out.field("expires", this.expires().format(ISO8601_DATETIME));
        if (this.data != null && !this.data.isSecret()) {
            this.data.print(out);
        }
        out.endObject();
    }

    public static enum Purpose {
        REGISTRATION,
        AUTHENTICATION;

    }
}

