/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.AuthenticatorType;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.mail.EmailOTP;
import com.pageseeder.base.mfa.recovery.BackupOTP;
import com.pageseeder.base.mfa.sms.SMSProviders;
import com.pageseeder.base.mfa.totp.TOTPVerifier;
import com.pageseeder.base.mfa.webauthn.WebAuthnManager;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MFA {
    private static final List<String> SUPPORTED_TYPES = Arrays.stream(AuthenticatorType.values()).map(AuthenticatorType::id).collect(Collectors.toList());
    private static final Logger LOGGER = LoggerFactory.getLogger(MFA.class);
    public static final String SESSION_CHALLENGE = "ps-challenge";
    public static final String SESSION_CHALLENGE_MEMBERID = "ps-challenge-memberid";
    public static final String SESSION_CHALLENGE_REMEMBER = "ps-challenge-remember";
    public static final String SESSION_AUTHENTICATOR = "ps-authenticator";

    private MFA() {
    }

    public static List<String> getSupportedTypes() {
        String allowed = GlobalSettings.get((String)"mfaSupport");
        if (allowed == null) {
            return SUPPORTED_TYPES;
        }
        String[] allowedTypes = allowed.split(",");
        ArrayList<String> supported = new ArrayList<String>(allowedTypes.length);
        for (String type : allowedTypes) {
            if (AuthenticatorType.fromId(type) == null) continue;
            supported.add(type);
        }
        return supported;
    }

    public static boolean isSupportedType(@Nullable String type) {
        if (type == null) {
            return false;
        }
        return MFA.getSupportedTypes().contains(type);
    }

    public static ChallengeResult checkChallenge(HttpServletRequest req, Database db) {
        String challengeId;
        ChallengeResult result = ChallengeResult.FAILURE;
        HttpSession session = req.getSession();
        if (session == null || session.getAttribute(SESSION_CHALLENGE) == null) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Attempted to access challenge without a challenge session");
            return ChallengeResult.INVALID_CHALLENGE;
        }
        String challenge = (String)session.getAttribute(SESSION_CHALLENGE);
        if (!challenge.equals(challengeId = req.getParameter("challenge"))) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Specified challenge does not match the expected ID: {}", challenge);
            return ChallengeResult.INVALID_CHALLENGE;
        }
        Long memberId = (Long)session.getAttribute(SESSION_CHALLENGE_MEMBERID);
        String authId = (String)session.getAttribute(SESSION_AUTHENTICATOR);
        if (AccountLockout.isAuthenticatorLocked(authId)) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Specified authenticator is locked: {}", authId);
            return ChallengeResult.LOCKED_OUT;
        }
        String code = req.getParameter("code");
        String credential = req.getParameter("credential");
        try {
            Authenticator authenticator = Authenticators.getAuthenticator((Database)db, (long)memberId, (String)authId);
            if (authenticator == null) {
                SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Specified authenticator not registered to this user");
                return ChallengeResult.INVALID_CHALLENGE;
            }
            result = MFA.verify(db, authenticator, challengeId, code != null ? code : credential);
            if (result.isSuccessful()) {
                SecurityLog.info(SecurityLog.EventType.AUTHENTICATION, "Successfully verified {} challenge of {}", authenticator.getType(), authenticator.getName());
                AccountLockout.unlockAuthenticator(authId);
            } else {
                SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Verification failed for {} challenge of {}", authenticator.getType(), authenticator.getName());
                AccountLockout.badAuthenticator(authId);
            }
        }
        catch (DatabaseException ex) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Unable to load authenticators for member: {}", new Object[]{memberId, ex});
            LOGGER.error("Unable to load authenticators for member: {}", (Object)memberId, (Object)ex);
        }
        return result;
    }

    public static ChallengeRequest createChallenge(Database db, Authenticator authenticator, Member member) {
        ChallengeManager manager = ChallengeManager.singleton();
        Challenge challenge = manager.getCurrentForAuthenticator(authenticator.getPublicId());
        if (challenge != null) {
            return ChallengeRequest.ready(challenge);
        }
        AuthenticatorType type = AuthenticatorType.fromId(authenticator.getType());
        ChallengeIssuer issuer = MFA.getIssuer(db, type);
        try {
            return issuer.issueChallenge(authenticator, member);
        }
        catch (Exception ex) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Error while creating challenge for authenticator: {}", authenticator.getPublicId());
            LOGGER.error("Unable to create challenge for authenticator: {}", (Object)authenticator.getPublicId(), (Object)ex);
            return ChallengeRequest.error();
        }
    }

    private static ChallengeIssuer getIssuer(Database db, @Nullable AuthenticatorType type) {
        if (type == AuthenticatorType.TOTP) {
            return new TOTPVerifier();
        }
        if (type == AuthenticatorType.RECOVERY) {
            return new BackupOTP(db);
        }
        if (type == AuthenticatorType.EMAIL_OTP) {
            return new EmailOTP(db);
        }
        if (type == AuthenticatorType.SMS_OTP) {
            return SMSProviders.getDefault();
        }
        if (type == AuthenticatorType.WEBAUTHN) {
            return new WebAuthnManager(db);
        }
        return (authenticator, member) -> ChallengeRequest.error();
    }

    public static ChallengeResult verify(Database db, Authenticator authenticator, String challengeId, String code) {
        AuthenticatorType type = AuthenticatorType.fromId(authenticator.getType());
        ChallengeVerifier verifier = MFA.getVerifier(db, type);
        try {
            ChallengeResult result = verifier.verifyChallenge(authenticator, challengeId, code);
            if (result.isSuccessful()) {
                authenticator.setLastUsed(new Date());
            }
            return result;
        }
        catch (Exception ex) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Error while verifying challenge for authenticator");
            LOGGER.error("Unable to verify challenge for authenticator: {}", (Object)authenticator.getId(), (Object)ex);
            return ChallengeResult.ERROR;
        }
    }

    private static ChallengeVerifier getVerifier(Database db, @Nullable AuthenticatorType type) {
        if (type == AuthenticatorType.TOTP) {
            return new TOTPVerifier();
        }
        if (type == AuthenticatorType.RECOVERY) {
            return new BackupOTP(db);
        }
        if (type == AuthenticatorType.EMAIL_OTP) {
            return new EmailOTP(db);
        }
        if (type == AuthenticatorType.SMS_OTP) {
            return SMSProviders.getDefault();
        }
        if (type == AuthenticatorType.WEBAUTHN) {
            return new WebAuthnManager(db);
        }
        return (authenticator, challengeId, response) -> ChallengeResult.INVALID_CHALLENGE;
    }

    public static ChallengeRequest challenge(Database db, Member member, HttpServletRequest req, List<Authenticator> authenticators) {
        HttpSession session = MFA.ensureChallengeSession(req, member);
        String authId = req.getParameter("authenticator");
        Authenticator authenticator = MFA.selectAuthenticator(authenticators, authId);
        if (authenticator == null) {
            return ChallengeRequest.error();
        }
        session.setAttribute(SESSION_AUTHENTICATOR, (Object)authenticator.getPublicId());
        ChallengeRequest challengeRequest = MFA.createChallenge(db, authenticator, member);
        if (challengeRequest.isSuccessful()) {
            SecurityLog.info(SecurityLog.EventType.AUTHENTICATION, "Challenge for authenticator {} sent to {}", authenticator, member.getUsername());
            Challenge challenge = challengeRequest.getChallenge();
            if (challenge != null) {
                session.setAttribute(SESSION_CHALLENGE, (Object)challenge.getId());
            }
        } else {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Unable to create challenge for authenticator {} to member: {}", authenticator, member.getUsername());
            return ChallengeRequest.error();
        }
        CSRF.attachAntiCSRFToken(session);
        return challengeRequest;
    }

    private static @Nullable Authenticator selectAuthenticator(List<Authenticator> authenticators, @Nullable String authenticatorId) {
        if (authenticators.isEmpty()) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "No authenticators available for challenge");
            return null;
        }
        if (authenticatorId == null || authenticatorId.isEmpty()) {
            SecurityLog.debug(SecurityLog.EventType.AUTHENTICATION, "Selecting authenticator most recently used available for challenge");
            return MFA.getMostRecentAuthenticator(authenticators);
        }
        for (Authenticator authenticator : authenticators) {
            if (!authenticatorId.equals(authenticator.getPublicId())) continue;
            SecurityLog.debug(SecurityLog.EventType.AUTHENTICATION, "Selecting authenticator requested by user");
            return authenticator;
        }
        SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "No authenticator found for id");
        return null;
    }

    private static Authenticator getMostRecentAuthenticator(List<Authenticator> authenticators) {
        Authenticator mostRecent = authenticators.get(0);
        for (Authenticator a : authenticators) {
            Date mostRecentDate;
            if (a.getLastUsed() == null || (mostRecentDate = mostRecent.getLastUsed()) != null && !mostRecentDate.before(a.getLastUsed())) continue;
            mostRecent = a;
        }
        return mostRecent;
    }

    private static HttpSession ensureChallengeSession(HttpServletRequest req, Member member) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            boolean isChallengeSession;
            boolean bl = isChallengeSession = session.getAttribute(SESSION_CHALLENGE_MEMBERID) != null;
            if (isChallengeSession) {
                return session;
            }
            session.invalidate();
        }
        session = req.getSession(true);
        if ("true".equals(req.getParameter("remember"))) {
            session.setAttribute(SESSION_CHALLENGE_REMEMBER, (Object)"true");
        }
        session.setAttribute(SESSION_CHALLENGE_MEMBERID, (Object)member.getId());
        session.setMaxInactiveInterval(600);
        return session;
    }

    public static boolean hasRememberMe(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        return session != null && "true".equals(session.getAttribute(SESSION_CHALLENGE_REMEMBER));
    }
}

