/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail.dkim;

import org.eclipse.jdt.annotation.Nullable;

public enum Canonicalization {
    SIMPLE("simple"){

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name + ":" + value;
        }

        @Override
        public String canonicalizeBody(@Nullable String body) {
            if (body == null || body.isEmpty()) {
                return Canonicalization.CRLF;
            }
            if (!Canonicalization.CRLF.equals(body.substring(body.length() - 2))) {
                return body + Canonicalization.CRLF;
            }
            while ("\r\n\r\n".equals(body.substring(body.length() - 4))) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    }
    ,
    RELAXED("relaxed"){

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name.trim().toLowerCase() + ":" + value.replaceAll("\\s+", " ").trim();
        }

        @Override
        public String canonicalizeBody(@Nullable String body) {
            if (body == null || body.isEmpty()) {
                return Canonicalization.CRLF;
            }
            if (!Canonicalization.CRLF.equals((body = body.replaceAll("[ \\t\\x0B\\f]+", " ").replace(" \r\n", Canonicalization.CRLF)).substring(body.length() - 2))) {
                return body + Canonicalization.CRLF;
            }
            while ("\r\n\r\n".equals(body.substring(body.length() - 4))) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    };

    private static final String CRLF = "\r\n";
    private final String type;

    private Canonicalization(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract String canonicalizeHeader(String var1, String var2);

    public abstract String canonicalizeBody(@Nullable String var1);
}

