/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.mail.Emails;
import com.pageseeder.common.util.Strings;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class MessageReceived {
    private @Nullable String textMailPart = null;
    private @Nullable String xhtmlMailPart = null;
    private final List<String> textContents = new ArrayList<String>();
    private final List<BodyPart> relatedParts = new ArrayList<BodyPart>();
    private final List<BodyPart> mixedParts = new ArrayList<BodyPart>();
    private @Nullable MimeMultipart multipart = null;
    private final Map<String, String> attachmentURIs = new HashMap<String, String>();
    private boolean announce = false;
    private boolean preserve = false;
    private boolean reply = false;
    private boolean hasAttachments = false;
    private boolean stripFooter = true;
    private @Nullable String footerStart = null;
    private @Nullable String preserveSubject = null;
    private final List<File> scannedFiles = new ArrayList<File>();

    public MessageReceived() {
    }

    public MessageReceived(@Nullable MimeMultipart multi, String subject) {
        this.multipart = multi;
        this.preserveSubject = subject;
    }

    public void setAnnounce(boolean announce) {
        this.announce = announce;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public boolean isAnnounce() {
        return this.announce;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public boolean isReply() {
        return this.reply;
    }

    public void setReply(boolean reply) {
        this.reply = reply;
    }

    public void setStripFooter(boolean stripFooter) {
        this.stripFooter = stripFooter;
    }

    public void setFooterStart(String footerStart) {
        this.footerStart = footerStart;
    }

    public boolean shouldStripFooter() {
        return this.stripFooter && this.reply;
    }

    public @Nullable String getFooterStart() {
        return this.footerStart;
    }

    public @Nullable MimeMultipart getMultipart() {
        return this.multipart;
    }

    public @Nullable String getPreserveSubject() {
        return this.preserveSubject;
    }

    public void addTextContent(String text) {
        this.textContents.add(text);
    }

    public void setTextMailPart(String text) {
        this.textMailPart = text;
    }

    public Iterator<String> getTextContents() {
        return this.textContents.iterator();
    }

    public void setXHTMLMailPart(@Nullable String xhtml) {
        if (!Strings.isEmpty((String)xhtml)) {
            this.xhtmlMailPart = xhtml;
        }
    }

    public @Nullable String getTextMailPart() {
        return this.textMailPart;
    }

    public @Nullable String getXHTMLMailPart() {
        return this.xhtmlMailPart;
    }

    public void addRelatedPart(BodyPart part) {
        this.relatedParts.add(part);
    }

    public boolean isRelatedMultipart() {
        return !this.relatedParts.isEmpty();
    }

    public Iterator<BodyPart> getRelatedParts() {
        return this.relatedParts.iterator();
    }

    public void addMixedPart(BodyPart part) {
        this.mixedParts.add(part);
    }

    public boolean isMixedMultipart() {
        return !this.mixedParts.isEmpty();
    }

    public Iterator<BodyPart> getMixedParts() {
        return this.mixedParts.iterator();
    }

    public void setHasAttachments() {
        this.hasAttachments = true;
    }

    public boolean hasAttachments() {
        return this.hasAttachments;
    }

    public void addAttachmentURI(String path, String userTitle) {
        this.attachmentURIs.put(path, userTitle);
    }

    public Iterator<String> getAttachmentURIs() {
        return this.attachmentURIs.keySet().iterator();
    }

    public String getAttachmentUserTitle(String path) {
        return this.attachmentURIs.get(path);
    }

    public void complete() throws MessagingException {
        if (this.textMailPart == null && this.xhtmlMailPart == null) {
            throw new MessagingException("Email must have a Text part or an HTML part");
        }
        if (this.textMailPart == null) {
            this.textMailPart = Emails.xhtmlToText(this.xhtmlMailPart);
        }
        if (this.xhtmlMailPart == null) {
            try {
                this.xhtmlMailPart = Emails.textToXHTML(this.textMailPart);
            }
            catch (IOException ex) {
                throw new MessagingException("Unable to parse text as markdown: " + ex.getMessage(), (Exception)ex);
            }
        }
    }

    public List<File> getScannedFiles() {
        return this.scannedFiles;
    }

    public void addScannedFile(File file) {
        this.scannedFiles.add(file);
    }
}

