/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.mail.From;
import org.eclipse.jdt.annotation.Nullable;

public enum EmailTemplate {
    accept_comment(From.member),
    auto_responder(From.pageseeder),
    change_email_confirm(From.pageseeder),
    change_email(From.pageseeder),
    change_password(From.pageseeder),
    comment_digest(From.group),
    external(From.pageseeder),
    membership_accept(From.member),
    membership_complete(From.group),
    membership_confirm(From.group),
    membership_new_member(From.member),
    new_comment(From.member),
    new_member(From.group),
    new_uri(From.member),
    new_version(From.member),
    out_of_office_change(From.pageseeder),
    out_of_office_warning(From.pageseeder),
    reject_comment(From.pageseeder),
    reminder_digest(From.pageseeder),
    reset_password_confirm(From.pageseeder),
    verification_code(From.pageseeder);

    private final String filename = this.name().replace('_', '-');
    private final From defaultFrom;

    private EmailTemplate(From from) {
        this.defaultFrom = from;
    }

    public String toString() {
        return this.filename;
    }

    From defaultFrom() {
        return this.defaultFrom;
    }

    public boolean hasUnsubscribeToken() {
        return this == comment_digest || this == external || this == membership_complete || this == new_comment || this == new_uri || this == new_version || this == out_of_office_change || this == out_of_office_warning;
    }

    public static @Nullable EmailTemplate forFilename(@Nullable String template) {
        for (EmailTemplate t : EmailTemplate.values()) {
            if (!t.filename.equals(template)) continue;
            return t;
        }
        return null;
    }
}

