/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.logback.MailEvent;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.EmailTemplate;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.mail.MailLogger;
import com.pageseeder.base.mail.NotificationSenderThread;
import com.pageseeder.base.mail.PSMimeMessage;
import com.pageseeder.base.mail.SMTPAuthenticator;
import com.pageseeder.base.mail.dkim.DKIMSigner;
import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.UnsubscribeToken;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class EmailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailSender.class);
    private static final Pattern ORGANIZATION_STYLE_PATH = Pattern.compile("/woconfig/([^/]+)/organization/(.+)");
    private static final TransformerFactory FACTORY = XMLHelpers.safeTransformerFactory();
    private static final Map<String, Templates> TEMPLATES_CACHE = new HashMap<String, Templates>();
    private static final String FROM_HEADER = "From";
    private static final String SENDER_HEADER = "Sender";
    private static final String REPLYTO_HEADER = "Reply-To";
    private static final String SUBJECT_HEADER = "Subject";
    private static final String LISTID_HEADER = "List-Id";
    private static final String LISTHELP_HEADER = "List-Help";
    private static final String LISTUNSUBSCRIBE_HEADER = "List-Unsubscribe";
    private static final String LISTUNSUBSCRIBEPOST_HEADER = "List-Unsubscribe-Post";
    private static final String LISTPOST_HEADER = "List-Post";
    private static final String LIST_ARCHIVE = "List-Archive";
    private static final String MESSAGEID_HEADER = "Message-ID";
    private static final String INREPLYTO_HEADER = "In-Reply-To";
    private static final String PRECEDENCE_HEADER = "Precedence";
    private static final String MAIL_CHARSET = "utf-8";
    private final @Nullable EmailTemplate template;
    private @Nullable String noGroupDefaultSubject = null;
    private final Map<String, String> defaultSubjects = new HashMap<String, String>();
    private @Nullable String xmlContent = null;
    private boolean forceDefaultTemplates = false;
    private boolean staticXMLContent = false;
    private @Nullable String textContent = null;
    private @Nullable String htmlContent = null;
    private @Nullable MimeMessage fixedMessage = null;
    private @Nullable String fixedMessageError = null;
    private @Nullable Multipart fixedContent = null;
    private @Nullable String fixedText = null;
    private final Map<String, String> notificationAttributes = new HashMap<String, String>();
    private From from = new From();
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, @Nullable Long> recipients = new HashMap<String, Long>();
    private List<URI> attachmentURIs = new ArrayList<URI>();
    private Map<String, byte[]> attachments = new HashMap<String, byte[]>();
    private final List<String> unsentAddresses = new ArrayList<String>();
    private final Map<Long, String> emailDomainsCache = new HashMap<Long, String>();
    private final Map<Long, String> urlHostsCache = new HashMap<Long, String>();
    private static final List<Pattern> IMAGES_IN_HTML_REGEX = new ArrayList<Pattern>();

    public EmailSender(@Nullable EmailTemplate template) {
        this.template = template;
        this.setBuiltInHeaders();
    }

    public EmailSender(@Nullable EmailTemplate template, boolean auto) {
        this.template = template;
        if (auto) {
            this.setBuiltInHeaders();
        }
    }

    public void setDefaultSubject(String group, @Nullable String subject) {
        this.defaultSubjects.put(group, this.defaultSubject(subject));
    }

    public void setDefaultSubject(@Nullable String subject) {
        this.noGroupDefaultSubject = this.defaultSubject(subject);
    }

    private String defaultSubject(@Nullable String subject) {
        return subject == null ? "PageSeeder email" : subject;
    }

    public static boolean checkTime() {
        String e1 = "lic";
        String e2 = "enseEx";
        String e3 = "pires";
        String e4 = e1 + e2 + e3;
        String ep = GlobalSettings.getString((String)e4, (String)"");
        if (ep.isEmpty()) {
            return true;
        }
        try {
            Date ed = ISO8601.CALENDAR_DATE.parse(ep);
            if (ed.after(new Date())) {
                return true;
            }
        }
        catch (ParseException ex) {
            System.out.println(ep + ": " + ex.getMessage());
        }
        return false;
    }

    public EmailSender copy() {
        EmailSender copy = new EmailSender(this.template);
        copy.defaultSubjects.putAll(this.defaultSubjects);
        copy.noGroupDefaultSubject = this.noGroupDefaultSubject;
        copy.attachments = new HashMap<String, byte[]>(this.attachments);
        copy.attachmentURIs = new ArrayList<URI>(this.attachmentURIs);
        copy.fixedContent = this.fixedContent;
        copy.fixedMessage = this.fixedMessage;
        copy.forceDefaultTemplates = this.forceDefaultTemplates;
        copy.from = this.from;
        copy.headers = new HashMap<String, String>(this.headers);
        copy.notificationAttributes.putAll(this.notificationAttributes);
        copy.xmlContent = this.xmlContent;
        copy.htmlContent = this.htmlContent;
        copy.staticXMLContent = this.staticXMLContent;
        copy.textContent = this.textContent;
        copy.recipients = new HashMap<String, Long>(this.recipients);
        return copy;
    }

    public void clearAllRecipients() {
        this.recipients.clear();
    }

    public void addRecipient(Member member, @Nullable Group group) {
        if (MemberRule.hasEmail(member)) {
            this.addRecipient(member.getEmail(), MemberRule.getFullName(member), group);
        }
    }

    public void addRecipient(String email, @Nullable String name, @Nullable Group group) {
        if (name == null) {
            this.recipients.put(email, group == null ? null : group.getId());
        } else {
            this.recipients.put(email + " " + name, group == null ? null : group.getId());
        }
    }

    public void addAttachment(URI uri) {
        this.attachmentURIs.add(uri);
    }

    public void addAttachment(@Nullable String name, byte @Nullable [] data) {
        if (name != null && data != null && data.length > 0) {
            this.attachments.put(name, data);
        }
    }

    public @Nullable String getHTMLContent() {
        return this.htmlContent;
    }

    public @Nullable String getTextContent() {
        return this.textContent;
    }

    public @Nullable EmailTemplate getTemplate() {
        return this.template;
    }

    public void setContent(String text, @Nullable String subject) {
        this.fixedText = text;
        this.headers.put(SUBJECT_HEADER, EmailSender.ensureSubject(subject));
    }

    public void setContent(Multipart content, @Nullable String subject) {
        this.fixedContent = content;
        this.headers.put(SUBJECT_HEADER, EmailSender.ensureSubject(subject));
    }

    public void setContent(MimeMessage incoming, @Nullable String subject, @Nullable String error) {
        this.fixedMessage = incoming;
        this.headers.put(SUBJECT_HEADER, EmailSender.ensureSubject(subject));
        this.fixedMessageError = error;
    }

    private static String ensureSubject(@Nullable String subject) {
        return subject != null ? subject : "Incoming Email";
    }

    public Collection<String> getUnsentAddresses() {
        return this.unsentAddresses;
    }

    public void setFromTemplate(EmailTemplate template, Member member) {
        switch (template.defaultFrom()) {
            case pageseeder: {
                this.setFromPageSeeder();
                break;
            }
            case group: {
                this.setFromGroup();
                break;
            }
            default: {
                this.setFromMember(member);
            }
        }
    }

    public void setFromSystem() {
        this.from.fromSystem = true;
    }

    public void setFromPageSeeder() {
        this.from.fromPageseeder = true;
    }

    public void setFromGroup() {
        this.from.fromGroup = true;
    }

    public void setFromMember(Member member) {
        this.from.fromMemberID = member.getId();
        this.from.fromMemberName = MemberRule.getFullName(member);
        this.from.fromMemberUsername = member.getUsername();
    }

    public void setFromComment(XLink comment, boolean modified) {
        Member author = comment.getMember();
        Member modifyMember = comment.getModifiedBy();
        String name = comment.getAuthorName();
        if (modified && modifyMember != null) {
            name = MemberRule.getFullName(modifyMember);
            author = modifyMember;
        } else if (author != null) {
            name = MemberRule.getFullName(author);
        }
        this.from = new From();
        this.from.fromMemberID = author == null ? null : author.getId();
        this.from.fromMemberName = name;
        this.from.fromMemberEmail = comment.getAuthorEmail();
    }

    public void setNotificationAttributes(@Nullable Map<String, String> attributes) {
        if (attributes != null) {
            this.notificationAttributes.putAll(attributes);
        }
    }

    public void setXMLSource(String xml) {
        this.setXMLSource(xml, false, false);
    }

    public void setXMLSource(String xml, boolean staticContent, boolean forceDefault) {
        this.xmlContent = xml;
        this.forceDefaultTemplates = forceDefault;
        this.staticXMLContent = staticContent;
    }

    public void createContent(@Nullable String email, @Nullable Group group) throws FoundationException, TransformerException {
        String xml;
        String textRoot;
        String htmlRoot;
        if (this.fixedContent != null || this.fixedMessage != null || this.fixedText != null) {
            return;
        }
        if (this.xmlContent == null) {
            throw new IllegalStateException("XML Content has not been set yet!");
        }
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        String templateName = group == null || GroupRule.getTemplate(group) == null ? globalTemplate : GroupRule.getTemplate(group);
        Template kit = this.forceDefaultTemplates || templateName == null ? Template.DEFAULT : new Template(templateName);
        TemplateFiles resources = new TemplateFiles(kit);
        File htmlTemplate = resources.find((TemplateZone)TemplateFiles.Zone.TEMPLATE, "notification/" + String.valueOf((Object)this.template) + ".xsl");
        File textTemplate = resources.find((TemplateZone)TemplateFiles.Zone.TEMPLATE, "notification/" + String.valueOf((Object)this.template) + "-text.xsl");
        if (htmlTemplate == null && textTemplate == null) {
            throw new FoundationException("Invalid template name " + String.valueOf((Object)this.template));
        }
        if (htmlTemplate != null && textTemplate != null && !(htmlRoot = htmlTemplate.getParentFile().getParentFile().getName()).equals(textRoot = textTemplate.getParentFile().getParentFile().getName())) {
            if (htmlRoot.equals(templateName)) {
                textTemplate = null;
            } else if (htmlRoot.equals(globalTemplate) && textRoot.equals("default")) {
                textTemplate = null;
            } else {
                htmlTemplate = null;
            }
        }
        if (this.staticXMLContent) {
            xml = this.xmlContent;
        } else {
            UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
            out.startObject("notification");
            this.addNotificationFields(email, group, out);
            out.field("message", this.xmlContent, OutputPrinter.FieldOption.XML_COPY);
            if (group != null && (this.template.hasUnsubscribeToken() || this.template == EmailTemplate.accept_comment) && this.template != EmailTemplate.membership_complete) {
                out.writeGroup(group);
            }
            this.addOrganization(group, out);
            out.endObject();
            xml = out.toString();
        }
        if (htmlTemplate != null) {
            this.htmlContent = this.runTransform(htmlTemplate, xml, true);
        }
        if (textTemplate != null) {
            this.textContent = this.runTransform(textTemplate, xml, false);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Collection<String> getRecipientTos() {
        return this.recipients.keySet();
    }

    public void send(@Nullable Database db, @Nullable Group group, @Nullable Boolean async) throws EmailException {
        boolean asynchronous;
        boolean bl = asynchronous = async == null ? GlobalSettings.getBoolean((String)"smtpAsync", (boolean)false) : async;
        if (Emails.areDisabled()) {
            return;
        }
        if (this.recipients.isEmpty()) {
            return;
        }
        if (asynchronous) {
            String author = this.from.fromMemberUsername != null ? this.from.fromMemberUsername : (this.from.fromMemberEmail != null ? this.from.fromMemberEmail : "system");
            NotificationSenderThread thread = NotificationSenderThread.newInstance(author, "Notification " + String.valueOf((Object)this.getTemplate()), group);
            thread.setSender(this);
            ProcessManager.getInstance().start(thread);
        } else {
            this.sendImmediately(db);
        }
    }

    private static String headerToString(MimeMessage message, String name) throws MessagingException {
        CharSequence[] h = message.getHeader(name);
        if (h == null) {
            return "";
        }
        return name + ": " + String.join((CharSequence)",", h) + "\n";
    }

    private void setMessageContent(String email, @Nullable Group group, Database db, PSMimeMessage message) throws MessagingException, EmailException {
        String replyTo;
        Object textpart;
        try {
            this.createContent(email, group);
        }
        catch (FoundationException | TransformerException ex) {
            throw new MessagingException("Failed to create email content: " + ex.getMessage(), ex);
        }
        if (this.textContent == null && this.htmlContent == null && this.fixedMessage == null && this.fixedContent == null && this.fixedText == null) {
            throw new MessagingException("No content to send!");
        }
        if (this.fixedMessage != null) {
            try {
                MimeMultipart mixed = new MimeMultipart("mixed");
                textpart = new MimeBodyPart();
                String string = (String)(this.fixedMessageError != null ? this.fixedMessageError + "\n\n" : "") + "---------- Original message ----------\n" + EmailSender.headerToString(this.fixedMessage, FROM_HEADER) + EmailSender.headerToString(this.fixedMessage, "To") + EmailSender.headerToString(this.fixedMessage, "Cc") + EmailSender.headerToString(this.fixedMessage, "Bcc") + EmailSender.headerToString(this.fixedMessage, "Date") + EmailSender.headerToString(this.fixedMessage, SUBJECT_HEADER);
                textpart.setContent((Object)string, "text/plain; charset=\"UTF-8\"");
                mixed.addBodyPart((BodyPart)textpart);
                MimeBodyPart msgpart = new MimeBodyPart();
                msgpart.setContent(this.fixedMessage.getContent(), this.fixedMessage.getContentType());
                mixed.addBodyPart((BodyPart)msgpart);
                message.setContent((Multipart)mixed);
                message.setHeader("Return-Path", "<>");
            }
            catch (IOException ex) {
                throw new MessagingException("Unable to get message content: " + ex.getMessage());
            }
        } else if (this.fixedContent != null) {
            message.setContent(this.fixedContent);
        } else if (this.fixedText != null) {
            message.setContent(this.fixedText, "text/plain; charset=\"UTF-8\"");
            message.setHeader("Content-Type", "text/plain; charset=\"UTF-8\"");
        } else if (this.textContent != null) {
            if (this.htmlContent == null) {
                message.setContent(this.textContent, "text/plain; charset=\"UTF-8\"");
                message.setHeader("Content-Type", "text/plain; charset=\"UTF-8\"");
            } else {
                MimeMultipart alternative = new MimeMultipart("alternative");
                textpart = new MimeBodyPart();
                textpart.setContent((Object)this.textContent, "text/plain; charset=\"UTF-8\"");
                alternative.addBodyPart((BodyPart)textpart);
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                this.setHTMLContent((MimePart)mimeBodyPart);
                alternative.addBodyPart((BodyPart)mimeBodyPart);
                message.setContent((Multipart)alternative);
            }
        } else if (this.setHTMLContent((MimePart)message)) {
            message.setHeader("Content-Type", "text/html; charset=\"UTF-8\"");
        }
        this.setDefaultHeaders(db, group);
        this.setHeadersFromContent(group == null ? this.noGroupDefaultSubject : this.defaultSubjects.get(group.getName()));
        try {
            Map<String, String> myheaders = this.getHeaders();
            for (Map.Entry entry : myheaders.entrySet()) {
                message.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (MessagingException ex) {
            throw new EmailException("Failed to add headers", ex);
        }
        String msgid = this.headers.get(MESSAGEID_HEADER);
        if (msgid != null) {
            message.setMessageId(msgid);
        }
        String subject = this.headers.get(SUBJECT_HEADER);
        try {
            message.setSubject(subject, MAIL_CHARSET);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Failed to set subject", messagingException);
        }
        String string = this.headers.get(FROM_HEADER);
        if (string != null) {
            int space = string.lastIndexOf(32);
            String name = string.substring(0, space);
            String add = string.substring(space + 2, string.length() - 1);
            try {
                message.setFrom((Address)new InternetAddress(add, name, MAIL_CHARSET));
            }
            catch (MessagingException | UnsupportedEncodingException ex) {
                throw new EmailException("Failed to set from", ex);
            }
        } else {
            throw new EmailException("No From specified!");
        }
        String sender = this.headers.get(SENDER_HEADER);
        if (sender != null) {
            int space = sender.lastIndexOf(32);
            String name = sender.substring(0, space);
            String add = sender.substring(space + 2, sender.length() - 1);
            try {
                message.setSender((Address)new InternetAddress(add, name, MAIL_CHARSET));
            }
            catch (MessagingException | UnsupportedEncodingException ex) {
                throw new EmailException("Failed to set sender", ex);
            }
        }
        if ((replyTo = this.headers.get(REPLYTO_HEADER)) != null) {
            int space = replyTo.lastIndexOf(32);
            String name = replyTo.substring(0, space);
            String add = replyTo.substring(space + 2, replyTo.length() - 1);
            try {
                message.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(add, name, MAIL_CHARSET)});
            }
            catch (MessagingException | UnsupportedEncodingException ex) {
                throw new EmailException("Failed to set sender", ex);
            }
        }
    }

    public void setDefaultHeaders(Database db, @Nullable Group group) {
        String domain = this.getEmailDomain(group);
        String senderName = "PageSeeder";
        Object senderEmail = "pageseeder@" + domain;
        EmailConfig config = null;
        if (group != null) {
            config = OrganizationManager.instance().getEmailConfig(GroupRule.getTemplate(group));
        }
        if (config == null) {
            config = OrganizationManager.instance().getEmailConfig(GlobalSettings.getGlobalTemplate((String)""));
        }
        if (config != null && config.getSenderName() != null && config.getSenderEmail() != null) {
            senderName = config.getSenderName();
            senderEmail = config.getSenderEmail();
        }
        if (this.from.fromSystem) {
            this.headers.put(FROM_HEADER, senderName + " System <system@" + domain + ">");
        } else if (this.from.fromPageseeder) {
            this.headers.put(FROM_HEADER, senderName + " (DO NOT REPLY) <" + (String)senderEmail + ">");
        } else if (this.from.fromGroup) {
            NotifyFromAddress type = EmailSender.toNotifyFromAddress(group, db);
            String fromEmail = EmailSender.toFrom(type, null, null, domain, group, (String)senderEmail);
            this.headers.put(FROM_HEADER, "PageSeeder (DO NOT REPLY) <" + fromEmail + ">");
            this.headers.put(SENDER_HEADER, "PageSeeder <pageseeder@" + domain + ">");
        } else if (this.from.fromMemberName != null) {
            NotifyFromAddress type = EmailSender.toNotifyFromAddress(group, db);
            String fromEmail = EmailSender.toFrom(type, this.from.fromMemberID, this.from.fromMemberEmail, domain, group, (String)senderEmail);
            this.headers.put(FROM_HEADER, this.from.fromMemberName + " <" + fromEmail + ">");
            this.headers.put(SENDER_HEADER, senderName + " <" + (String)senderEmail + ">");
        }
    }

    private String getFromAddressForLog(Database db, @Nullable Group group) {
        String header = this.headers.get(FROM_HEADER);
        if (header != null) {
            return header.substring(header.lastIndexOf(60) + 1, header.length() - 1);
        }
        String domain = this.getEmailDomain(group);
        Object senderemail = "pageseeder@" + domain;
        EmailConfig config = null;
        if (group != null) {
            config = OrganizationManager.instance().getEmailConfig(GroupRule.getTemplate(group));
        }
        if (config == null) {
            config = OrganizationManager.instance().getEmailConfig(GlobalSettings.getGlobalTemplate((String)""));
        }
        if (config != null && config.getSenderName() != null && config.getSenderEmail() != null) {
            senderemail = config.getSenderEmail();
        }
        if (this.from.fromSystem) {
            return "system@" + domain;
        }
        if (this.from.fromPageseeder) {
            return senderemail;
        }
        if (this.from.fromGroup) {
            NotifyFromAddress type = EmailSender.toNotifyFromAddress(group, db);
            return EmailSender.toFrom(type, null, null, domain, group, (String)senderemail);
        }
        if (this.from.fromMemberName != null) {
            NotifyFromAddress type = EmailSender.toNotifyFromAddress(group, db);
            return EmailSender.toFrom(type, this.from.fromMemberID, this.from.fromMemberEmail, domain, group, (String)senderemail);
        }
        return null;
    }

    public void setHeadersFromContent(String backupSubject) {
        if (this.fixedMessage == null && this.fixedContent == null && this.fixedText == null) {
            if (this.htmlContent != null) {
                String inReplyTo;
                String messageId;
                String listArchive;
                String listPost;
                String listUnsubscribePost;
                String listUnsubscribe;
                String listHelp;
                String subject;
                String toEmail = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"to-email\" content=\"", "\"/>");
                if (toEmail != null) {
                    this.recipients.clear();
                    this.recipients.put(toEmail, null);
                }
                if ((subject = EmailSender.getDelimitedValue(this.htmlContent, "<title>", "</title>")) == null) {
                    subject = backupSubject;
                }
                if (subject != null) {
                    this.headers.put(SUBJECT_HEADER, subject);
                }
                String fromName = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"from-name\" content=\"", "\"/>");
                String fromEmail = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"from-email\" content=\"", "\"/>");
                if (fromEmail != null) {
                    this.headers.put(FROM_HEADER, (fromName != null ? fromName : "") + " <" + fromEmail + ">");
                }
                String senderName = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"sender-name\" content=\"", "\"/>");
                String senderEmail = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"sender-email\" content=\"", "\"/>");
                if (senderEmail != null) {
                    this.headers.put(SENDER_HEADER, (senderName != null ? senderName : "") + " <" + senderEmail + ">");
                }
                String replytoName = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"replyto-name\" content=\"", "\"/>");
                String replytoEmail = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"replyto-email\" content=\"", "\"/>");
                if (replytoEmail != null) {
                    this.headers.put(REPLYTO_HEADER, (replytoName != null ? replytoName : "") + " <" + replytoEmail + ">");
                }
                String listName = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-name\" content=\"", "\"/>");
                String listId = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-id\" content=\"", "\"/>");
                if (listId != null) {
                    this.headers.put(LISTID_HEADER, (listName != null ? listName : "") + " <" + listId + ">");
                    this.headers.put(PRECEDENCE_HEADER, "List");
                }
                if ((listHelp = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-help\" content=\"", "\"/>")) != null) {
                    this.headers.put(LISTHELP_HEADER, "<" + listHelp + ">");
                }
                if ((listUnsubscribe = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-unsubscribe\" content=\"", "\"/>")) != null) {
                    this.headers.put(LISTUNSUBSCRIBE_HEADER, "<" + listUnsubscribe + ">");
                }
                if ((listUnsubscribePost = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-unsubscribe-post\" content=\"", "\"/>")) != null) {
                    this.headers.put(LISTUNSUBSCRIBEPOST_HEADER, "<" + listUnsubscribePost + ">");
                }
                if ((listPost = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-post\" content=\"", "\"/>")) != null) {
                    this.headers.put(LISTPOST_HEADER, "<" + listPost + ">");
                }
                if ((listArchive = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"list-archive\" content=\"", "\"/>")) != null) {
                    this.headers.put(LIST_ARCHIVE, "<" + listArchive + ">");
                }
                if ((messageId = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"message-id\" content=\"", "\"/>")) != null) {
                    this.headers.put(MESSAGEID_HEADER, "<" + messageId + ">");
                }
                if ((inReplyTo = EmailSender.getDelimitedValue(this.htmlContent, "<meta name=\"in-reply-to\" content=\"", "\"/>")) != null) {
                    this.headers.put(INREPLYTO_HEADER, "<" + inReplyTo + ">");
                }
            } else if (backupSubject != null) {
                this.headers.put(SUBJECT_HEADER, backupSubject);
            }
        }
    }

    private boolean setHTMLContent(MimePart part) throws MessagingException {
        HashMap<String, File> images = new HashMap<String, File>();
        String newHTML = this.parseHTMLImages(images);
        if (images.isEmpty()) {
            part.setContent((Object)this.htmlContent, "text/html; charset=\"UTF-8\"");
        } else {
            MimeMultipart mp = new MimeMultipart("related");
            MimeBodyPart htmlpart = new MimeBodyPart();
            htmlpart.setContent((Object)newHTML, "text/html; charset=\"UTF-8\"");
            mp.addBodyPart((BodyPart)htmlpart);
            for (Map.Entry image : images.entrySet()) {
                String id = (String)image.getKey();
                File file = (File)image.getValue();
                MimeBodyPart imgpart = new MimeBodyPart();
                imgpart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                imgpart.setContentID("<" + id + ">");
                imgpart.setFileName(file.getName());
                imgpart.setDisposition("inline");
                mp.addBodyPart((BodyPart)imgpart);
            }
            part.setContent((Multipart)mp);
        }
        return images.isEmpty();
    }

    private void addAttachments(PSMimeMessage message) throws MessagingException {
        MimeBodyPart mbp2;
        if (this.attachmentURIs.isEmpty() && this.attachments.isEmpty()) {
            return;
        }
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart mbp1 = new MimeBodyPart();
        try {
            mbp1.setContent(message.getContent(), message.getContentType());
        }
        catch (IOException ex) {
            throw new MessagingException("Failed to load existing content: " + ex.getMessage(), (Exception)ex);
        }
        mp.addBodyPart((BodyPart)mbp1);
        for (URI uRI : this.attachmentURIs) {
            if (URIRule.isPSML(uRI)) continue;
            mbp2 = new MimeBodyPart();
            String[] fns = URIRule.getFilename(uRI);
            mbp2.setFileName(fns[0] + fns[1]);
            mbp2.setDescription(uRI.getUserTitle(), "UTF-8");
            mbp2.setHeader("Content-Type", URIRule.getContentType(uRI));
            mbp2.setDataHandler(new DataHandler((DataSource)new FileDataSource(new File(URIRule.getRealPath(uRI.getPath())))));
            mp.addBodyPart((BodyPart)mbp2);
        }
        for (Map.Entry entry : this.attachments.entrySet()) {
            mbp2 = new MimeBodyPart();
            mbp2.setFileName((String)entry.getKey());
            String type = this.getMediaType((String)entry.getKey());
            mbp2.setHeader("Content-Type", EmailSender.toSafeHeader(type));
            mbp2.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])entry.getValue(), type)));
            mp.addBodyPart((BodyPart)mbp2);
        }
        message.setContent((Multipart)mp);
    }

    private static String toSafeHeader(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("[\\r\\n]", " ");
    }

    public String getMediaType(String filename) {
        String type = "application/octet-stream";
        int i = filename.lastIndexOf(46);
        if (i != -1) {
            type = Settings.getString((SettingsFile)SettingsFile.MIME, (String)filename.substring(i + 1).toLowerCase(), (String)type);
        }
        return type;
    }

    private void addOrganization(Group group, OutputPrinter out) {
        String project;
        OrganizationManager manager = OrganizationManager.instance();
        EmailConfig config = manager.getEmailConfig(project = group != null ? group.getOwnerDirectory() : "default");
        if (config == null || config.getNotificationXML() == null) {
            project = GlobalSettings.getGlobalTemplate((String)"default");
            config = manager.getEmailConfig(project);
        }
        if (config != null && config.getNotificationXML() != null) {
            out.startObject("organization");
            out.field("project", project);
            out.field("config", config.getNotificationXML(), OutputPrinter.FieldOption.XML_COPY);
            SecurityConfig securityConfig = manager.getSecurityConfig();
            Map<SecurityConfig.TokenType, Duration> tokens = securityConfig.getTokenExpirations();
            out.startCollection("tokens", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Map.Entry<SecurityConfig.TokenType, Duration> entry : tokens.entrySet()) {
                out.startObject("token");
                out.field("type", entry.getKey().toString());
                out.field("expiration", entry.getValue().toString());
                out.endObject();
            }
            out.endCollection();
            out.endObject();
        }
    }

    private String runTransform(File templates, String content, boolean html) throws TransformerException {
        if (templates == null || !templates.exists()) {
            return null;
        }
        Transformer t = EmailSender.loadTransformer(templates);
        if (html) {
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("doctype-public", "-//W3C//DTD XHTML Basic 1.0//EN");
        } else {
            t.setOutputProperty("method", "text");
        }
        StringWriter out = new StringWriter();
        t.transform(new SAXSource(new InputSource(new StringReader(content))), new StreamResult(out));
        return out.toString();
    }

    private static Transformer loadTransformer(File templates) throws TransformerConfigurationException {
        Templates t = TEMPLATES_CACHE.get(templates.getAbsolutePath());
        if (t == null) {
            t = FACTORY.newTemplates(new StreamSource(templates));
            TEMPLATES_CACHE.put(templates.getAbsolutePath(), t);
        }
        return t.newTransformer();
    }

    public static void clearCache() {
        TEMPLATES_CACHE.clear();
    }

    private void addNotificationFields(String email, Group group, OutputPrinter out) {
        out.field("template", this.template.toString());
        if (email != null && group != null && this.template.hasUnsubscribeToken()) {
            out.field("unsubscribetoken", UnsubscribeToken.generateToken(group.getId(), email, null));
        }
        for (Map.Entry<String, String> n : this.notificationAttributes.entrySet()) {
            String name = n.getKey();
            if ("emaildomain".equals(name) || "hosturl".equals(name)) continue;
            out.field(name, n.getValue());
        }
        out.field("emaildomain", this.getEmailDomain(group));
        out.field("hosturl", URLs.asString((String)Settings.getServerScheme(), (String)this.getURLHost(group), (int)Settings.getServerPort(), (String)GlobalSettings.getSitePrefix()));
    }

    private void setBuiltInHeaders() {
        this.headers.put("Auto-Submitted", "auto-generated");
        this.headers.put("com.pageseeder.mail.Bounce", "true");
    }

    void sendImmediately(Database db) throws EmailException {
        if (!EmailSender.checkTime()) {
            return;
        }
        String currentDestination = "";
        Group currentGroup = null;
        try {
            HashMap<Long, Group> groupsCache = new HashMap<Long, Group>();
            HashMap<String, DKIMSigner> dkimCache = new HashMap<String, DKIMSigner>();
            SendFailedException lastex = null;
            for (Map.Entry<String, Long> recipient : this.recipients.entrySet()) {
                InternetAddress address;
                Group group;
                String destination = recipient.getKey();
                int space = destination.indexOf(32);
                String email = space == -1 ? destination : destination.substring(0, space);
                String name = space == -1 ? null : destination.substring(1 + space);
                currentDestination = email;
                Long groupid = recipient.getValue();
                Group group2 = group = groupid == null ? null : (Group)groupsCache.get(groupid);
                if (groupid != null && group == null && db != null) {
                    try {
                        group = DatabaseQuery.getGroupById((Database)db, (Long)groupid);
                    }
                    catch (QueryFailedException ex) {
                        LOGGER.error("EmailUtilities: Invalid group ID: {}", (Object)groupid);
                        this.unsentAddresses.add(email);
                        continue;
                    }
                    groupsCache.put(groupid, group);
                }
                currentGroup = group;
                PSMimeMessage message = EmailSender.createMessage(group, dkimCache);
                try {
                    address = new InternetAddress(email, name, MAIL_CHARSET);
                    message.setRecipient(Message.RecipientType.TO, (Address)address);
                }
                catch (MessagingException ex) {
                    MailLogger.logError(MailEvent.newOutgoing(this.getFromAddressForLog(db, group), email, this.headers.get(SUBJECT_HEADER), "Invalid Address", ex));
                    LOGGER.error("EmailUtilities: Invalid Address: {}", (Object)email);
                    this.unsentAddresses.add(email);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("EmailUtilities: Invalid Address encoding: {}", (Object)email);
                    this.unsentAddresses.add(email);
                    continue;
                }
                try {
                    this.setMessageContent(email, group, db, message);
                }
                catch (MessagingException ex) {
                    MailLogger.logError(MailEvent.newOutgoing(this.getFromAddressForLog(db, group), email, this.headers.get(SUBJECT_HEADER), "Failed to set content", ex));
                    throw new EmailException("Failed to set content", ex);
                }
                try {
                    this.addAttachments(message);
                }
                catch (MessagingException ex) {
                    MailLogger.logError(MailEvent.newOutgoing(this.getFromAddressForLog(db, group), email, message.getSubject(), "Failed to add attachments", ex));
                    throw new EmailException("Failed to add attachments", ex);
                }
                try {
                    Transport.send((Message)message);
                    MailLogger.logInfo(MailEvent.newOutgoing(this.getFromAddressForLog(db, group), email, message.getSubject()));
                }
                catch (SendFailedException ex) {
                    lastex = ex;
                    this.unsentAddresses.add(address.toString());
                    MailLogger.logError(MailEvent.newOutgoing(this.getFromAddressForLog(db, group), email, message.getSubject(), "Failed to send email", ex));
                }
            }
            if (this.unsentAddresses.size() == this.recipients.size() && lastex != null) {
                throw new EmailException("Unable to send email: " + lastex.getMessage(), lastex);
            }
        }
        catch (MessagingException ex) {
            MailLogger.logError(MailEvent.newOutgoing(this.getFromAddressForLog(db, currentGroup), currentDestination, this.headers.get(SUBJECT_HEADER), "Unable to send email", ex));
            throw new EmailException("Unable to send email: " + ex.getMessage(), ex);
        }
    }

    private String parseHTMLImages(Map<String, File> images) {
        String host = GlobalSettings.getString((String)"webSiteAddress", (String)"");
        if (!("localhost".equals(host) || host.endsWith(".localhost") || "true".equals(GlobalSettings.getString((String)"emailEmbedImages", (String)"false")))) {
            return this.htmlContent;
        }
        String newHTML = this.htmlContent;
        boolean found = false;
        for (Pattern pattern : IMAGES_IN_HTML_REGEX) {
            Matcher m = pattern.matcher(newHTML);
            StringBuilder newContents = new StringBuilder();
            while (m.find()) {
                Object newImageRef;
                File imageFile;
                found = true;
                Object filepath = m.group(4);
                Matcher om = ORGANIZATION_STYLE_PATH.matcher((CharSequence)filepath);
                if (om.matches()) {
                    filepath = "/WEB-INF/config/template/" + om.group(1) + "/organization/style/" + om.group(2);
                }
                if ((imageFile = new File(Settings.getContextPath(), (String)filepath)).exists()) {
                    String imageId = MD5.hash((String)filepath);
                    newImageRef = m.group(1) + "cid:" + imageId + m.group(5);
                    images.putIfAbsent(imageId, imageFile);
                } else {
                    LOGGER.warn("Ignoring invalid image in an email: {}", (Object)imageFile.getAbsolutePath());
                    newImageRef = m.group();
                }
                m.appendReplacement(newContents, (String)newImageRef);
            }
            m.appendTail(newContents);
            newHTML = newContents.toString();
        }
        if (!found) {
            return this.htmlContent;
        }
        return newHTML;
    }

    private static @Nullable String getDelimitedValue(String source, String start, String end) {
        int j;
        String value = null;
        int i = source.indexOf(start);
        if (i != -1 && (j = source.indexOf(end, i)) != -1) {
            value = source.substring(i + start.length(), j).replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'").replace("&amp;", "&");
        }
        return value;
    }

    private static PSMimeMessage createMessage(@Nullable Group group, Map<String, DKIMSigner> dkimCache) throws EmailException {
        DKIMSigner dkimSigner;
        try {
            String selector;
            String domain;
            String project = group != null ? group.getOwnerDirectory() : "default";
            EmailConfig config = OrganizationManager.instance().getEmailConfig(project);
            if (config == null) {
                project = GlobalSettings.getGlobalTemplate((String)"default");
                config = OrganizationManager.instance().getEmailConfig(project);
            }
            if (config == null || (config.getDKIMDomain() == null || config.getDKIMSelector() == null) && config.getDKIMDisabled() != Boolean.TRUE) {
                if (GlobalSettings.getBoolean((String)"disableDefaultDKIM", (boolean)false)) {
                    return new PSMimeMessage(EmailSender.newSession(), null);
                }
                project = "default";
                domain = "pageseeder.com";
                selector = "psmail";
            } else {
                if (config.getDKIMDisabled() == Boolean.TRUE) {
                    return new PSMimeMessage(EmailSender.newSession(), null);
                }
                domain = config.getDKIMDomain();
                selector = config.getDKIMSelector();
            }
            dkimSigner = dkimCache.get(project);
            if (dkimSigner == null) {
                RSAPrivateKey privKey = OrganizationManager.getDKIMPrivateKey(project);
                dkimSigner = new DKIMSigner(domain, selector, privKey);
                dkimCache.put(project, dkimSigner);
            }
        }
        catch (Exception ex) {
            throw new EmailException("Could not create DKIM Signer " + ex.getMessage());
        }
        return new PSMimeMessage(EmailSender.newSession(), dkimSigner);
    }

    private static Session newSession() {
        Properties props = new Properties();
        props.put("mail.smtp.host", GlobalSettings.getString((String)"smtpServerAddress", (String)""));
        props.put("mail.smtp.port", GlobalSettings.getString((String)"smtpServerPort", (String)"25"));
        props.put("mail.smtp.ssl.enable", GlobalSettings.getBoolean((String)"smtpServerSSL", (boolean)false) ? "true" : "false");
        props.put("mail.smtp.starttls.enable", GlobalSettings.getBoolean((String)"smtpServerSTARTTLS", (boolean)false) ? "true" : "false");
        String username = GlobalSettings.get((String)"smtpServerUsername");
        String password = GlobalSettings.get((String)"smtpServerPassword");
        if (!Strings.isEmpty((String)username)) {
            props.put("mail.smtp.auth", "true");
            return Session.getInstance((Properties)props, (Authenticator)new SMTPAuthenticator(username, password));
        }
        return Session.getInstance((Properties)props, null);
    }

    private static NotifyFromAddress toNotifyFromAddress(@Nullable Group group, Database db) {
        Properties properties = EmailSender.getGroupPropertiesSilently(group, db);
        if (properties == null) {
            return NotifyFromAddress.NOREPLY;
        }
        String from = properties.getProperty("notifyFromAddress");
        if ("group".equals(from)) {
            return NotifyFromAddress.GROUP;
        }
        if ("groupReturned".equals(from) && Emails.isAddress(properties.getProperty("mailReturnedAddress"))) {
            return NotifyFromAddress.GROUP_RETURNED;
        }
        if ("suppressed".equals(from)) {
            return NotifyFromAddress.SUPPRESSED;
        }
        return NotifyFromAddress.NOREPLY;
    }

    private static @Nullable Properties getGroupPropertiesSilently(@Nullable Group group, Database db) {
        Properties properties = null;
        if (group != null && db != null) {
            try {
                properties = GroupProperties.get(db, group);
            }
            catch (DatabaseException | IOException ex) {
                LOGGER.error("Unable to get the group properties", ex);
            }
        }
        return properties;
    }

    private static String toFrom(NotifyFromAddress type, @Nullable Long memberId, @Nullable String email, String domain, Group group, String senderEmail) {
        switch (type) {
            case GROUP: {
                return group.getName() + "@" + domain;
            }
            case GROUP_RETURNED: {
                return group.getName() + "//returned@" + domain;
            }
            case SUPPRESSED: {
                return memberId == null ? senderEmail : "email_suppressed@" + domain;
            }
        }
        if (memberId != null) {
            return EmailSender.generateNoReplyEmail(memberId.toString()) + domain;
        }
        if (email != null) {
            return EmailSender.generateNoReplyEmail(email) + domain;
        }
        return senderEmail;
    }

    private static String generateNoReplyEmail(String value) {
        int a = 32;
        int b = 42;
        return RuleUtils.encodeKey("n37rqi5th2" + value).substring(32, 42).toLowerCase().replaceAll("[^a-z0-9]", "0") + "--noreply@";
    }

    private String getEmailDomain(@Nullable Group group) {
        String domain;
        EmailConfig config = null;
        if (group != null) {
            config = OrganizationManager.instance().getEmailConfig(group.getOwnerDirectory());
        }
        if (config == null) {
            config = OrganizationManager.instance().getEmailConfig(GlobalSettings.getGlobalTemplate((String)""));
        }
        if (config == null || config.getEmailDomain() == null) {
            domain = GlobalSettings.getString((String)"emailSenderDomain", (String)GlobalSettings.getString((String)"emailDomain", (String)""));
            if (group != null && "pshosts".equals(GlobalSettings.get((String)"emailDomain")) && (domain = this.emailDomainsCache.get(group.getId())) == null) {
                try {
                    GroupURI gu = GroupURIRule.getDefaultGroupURI(group);
                    if (gu != null) {
                        domain = gu.getHost().getName();
                        this.emailDomainsCache.put(group.getId(), domain);
                    }
                }
                catch (DatabaseException ex) {
                    LOGGER.warn("Failed to load group host to determine email domain", (Throwable)ex);
                    domain = null;
                }
            }
        } else {
            domain = config.getEmailDomain();
        }
        if (domain == null || domain.isEmpty() || "pshosts".equals(domain)) {
            domain = GlobalSettings.get((String)"webSiteAddress");
        }
        return domain;
    }

    private String getURLHost(Group group) {
        String domain = GlobalSettings.get((String)"emailDomain");
        if (group != null && "pshosts".equals(domain)) {
            String host = this.urlHostsCache.get(group.getId());
            if (host == null) {
                try {
                    GroupURI gu = GroupURIRule.getDefaultGroupURI(group);
                    if (gu != null) {
                        host = gu.getHost().getName();
                        this.urlHostsCache.put(group.getId(), host);
                    }
                }
                catch (DatabaseException ex) {
                    LOGGER.warn("Failed to load group host to find email domain", (Throwable)ex);
                }
            }
            return host;
        }
        return GlobalSettings.get((String)"webSiteAddress");
    }

    static {
        String url1 = "([^\"]{0,500})(/weborganic/email/[^\"]{0,500})";
        String url2 = "([^\"]{0,500})(/woconfig/[^/]*/organization/[^\"]{0,500})";
        IMAGES_IN_HTML_REGEX.add(Pattern.compile("(<img\\s{1,500}src=\")(" + url1 + ")(\")", 8));
        IMAGES_IN_HTML_REGEX.add(Pattern.compile("(<img\\s{1,500}src=\")(" + url2 + ")(\")", 8));
        IMAGES_IN_HTML_REGEX.add(Pattern.compile("(\\sbackground=\")(" + url1 + ")(\")", 8));
        IMAGES_IN_HTML_REGEX.add(Pattern.compile("(\\sbackground=\")(" + url2 + ")(\")", 8));
    }

    private static final class From {
        private boolean fromSystem = false;
        private boolean fromPageseeder = false;
        private boolean fromGroup = false;
        private @Nullable Long fromMemberID = null;
        private @Nullable String fromMemberName = null;
        private @Nullable String fromMemberEmail = null;
        private @Nullable String fromMemberUsername = null;

        private From() {
        }
    }

    private static enum NotifyFromAddress {
        SUPPRESSED,
        GROUP,
        GROUP_RETURNED,
        NOREPLY;

    }
}

