/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.PropertyDefinerBase;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import org.slf4j.LoggerFactory;

public final class Location
extends PropertyDefinerBase
implements PropertyDefiner {
    public static final String LOGS_FOLDER_GLOBAL_PROPERTY = "logsFolder";

    public String getPropertyValue() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager manager = context.getStatusManager();
        File folder = Location.getFolder();
        if (folder.exists() && !folder.isDirectory()) {
            manager.add((Status)new ErrorStatus("folder " + folder.getAbsolutePath() + " exists but is not a directory!", (Object)this));
        }
        String location = folder.getAbsolutePath();
        manager.add((Status)new InfoStatus("Logs will be send to: " + location, (Object)this));
        return location;
    }

    public static File getFolder() {
        String location = GlobalSettings.get((String)LOGS_FOLDER_GLOBAL_PROPERTY);
        return location != null ? new File(location) : Location.getDefault();
    }

    public static File getDefault() {
        File context = new File(Settings.getContextPath());
        return new File(context, "WEB-INF" + File.separatorChar + "state" + File.separatorChar + "logs");
    }
}

