/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.base.logback.config.Location;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public abstract class XLoggerAdaptor {
    private static final String SELF = "{}";
    private static final List<XLoggerAdaptor> ADAPTORS = new CopyOnWriteArrayList<XLoggerAdaptor>();
    private long lastChecked = 0L;
    private final String name;
    private final File directory;
    private final Logger logger;

    protected XLoggerAdaptor(String name) {
        this.name = name.toLowerCase();
        this.logger = LoggerFactory.getLogger((String)("PAGESEEDER." + name));
        this.directory = new File(Location.getFolder(), this.getLogDirectory());
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IllegalStateException("Invalid log directory: " + this.directory.getAbsolutePath());
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalStateException("Invalid log directory (not a folder): " + this.directory.getAbsolutePath());
        }
        this.logger.info(MarkerFactory.getMarker((String)"comment"), "PageSeeder restarting");
        ADAPTORS.add(this);
    }

    public final String getLogDirectory() {
        return this.name;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final String getLogFileName() {
        return this.name + ".xlog";
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final void debug(XLoggable xlog) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.debug(SELF, (Object)xlog);
    }

    public final void info(XLoggable xlog) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.info(SELF, (Object)xlog);
    }

    public final void warn(XLoggable xlog) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.warn(SELF, (Object)xlog);
    }

    public final void error(XLoggable xlog) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.error(SELF, (Object)xlog);
    }

    public final void debug(XLoggable xlog, Throwable throwable) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.debug(SELF, (Object)xlog, (Object)throwable);
    }

    public final void info(XLoggable xlog, Throwable throwable) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.info(SELF, (Object)xlog, (Object)throwable);
    }

    public final void warn(XLoggable xlog, Throwable throwable) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.warn(SELF, (Object)xlog, (Object)throwable);
    }

    public final void error(XLoggable xlog, Throwable throwable) {
        this.lastChecked = System.currentTimeMillis();
        this.logger.error(SELF, (Object)xlog, (Object)throwable);
    }

    protected static void ensureRollover() {
        long oneHour = 3600000L;
        long now = System.currentTimeMillis();
        for (XLoggerAdaptor adaptor : ADAPTORS) {
            if (now - adaptor.lastChecked <= 3600000L) continue;
            adaptor.logger.info(MarkerFactory.getMarker((String)"silent"), "");
            adaptor.lastChecked = now;
        }
    }
}

