/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.DailyLogFileFilter;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.logback.XLogs;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TicketLog
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketLog.class);
    private static final int MAX_RESULTS = 10000;
    private static final Comparator<File> FILE_AGE = Comparator.comparingLong(File::lastModified);
    private final File directory;
    private final String id;
    private final @Nullable Long groupid;
    private final @Nullable String groupname;
    private boolean accessLogs = false;
    private Date date;
    private int page = 1;
    private @Nullable LocalDateTime fromDateTime = null;
    private @Nullable LocalDateTime toDateTime = null;
    private final List<String> includeTypes = new ArrayList<String>();
    private final List<String> excludeTypes = new ArrayList<String>();
    private List<String> permissions = new ArrayList<String>();
    private List<String> methods = new ArrayList<String>();
    private int results = 10000;
    private boolean multipleDays = false;
    private boolean singleDayContinueAfterNoEventsFound = false;

    public TicketLog(XLoggerAdaptor xlogger, String id, @Nullable Long groupId, @Nullable String groupName) {
        this.id = Objects.requireNonNull(id, "Ticket ID");
        this.directory = xlogger.getDirectory();
        this.date = new Date();
        this.groupid = groupId;
        this.groupname = groupName;
    }

    public void setDate(@Nullable Date date) {
        this.date = date != null ? date : new Date();
    }

    public void setLimits(@Nullable LocalDateTime from, @Nullable LocalDateTime to) {
        this.fromDateTime = from;
        this.toDateTime = to;
    }

    public void setAccessLogs(boolean accessLogs) {
        this.accessLogs = accessLogs;
    }

    public void setMultipleDays(boolean multipleDays) {
        this.multipleDays = multipleDays;
    }

    public void addIncludeType(@Nullable String type) {
        if (type != null) {
            this.includeTypes.add(type.toLowerCase());
        }
    }

    public void addExcludeType(@Nullable String type) {
        if (type != null) {
            this.excludeTypes.add(type.toLowerCase());
        }
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public void serSingleDayContinueAfterNoEventsFound(boolean keepGoing) {
        this.singleDayContinueAfterNoEventsFound = keepGoing;
    }

    public void setPagination(int page, int results) {
        if (page > 0) {
            this.page = page;
        }
        if (results > 0) {
            this.results = results;
        }
    }

    public void setDate(String date) throws ParseException {
        this.date = ISO8601.parseAuto((String)date);
    }

    public void toXML(XMLWriter xml) throws IOException {
        XLoggerAdaptor.ensureRollover();
        xml.openElement("events", true);
        xml.attribute("ticket", this.id);
        if (this.groupid != null) {
            xml.attribute("groupid", String.valueOf(this.groupid));
        }
        if (this.groupname != null) {
            xml.attribute("groupname", this.groupname);
        }
        xml.attribute("date", ISO8601.CALENDAR_DATE.format(this.date.getTime()));
        int from = (this.page - 1) * this.results;
        int to = from + this.results;
        XMLStringWriter temp = new XMLStringWriter(XML.NamespaceAware.No);
        TicketFilter filter = new TicketFilter((XMLWriter)temp, this.id, this.groupid, this.groupname, from, to, this.fromDateTime, this.toDateTime, this.accessLogs, this.permissions, this.methods);
        filter.excludeTypes.addAll(this.excludeTypes);
        filter.includeTypes.addAll(this.includeTypes);
        try {
            this.parseDayLogs(filter, this.date);
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOGGER.error("unable to filter logs", (Throwable)ex);
            throw new IOException(ex);
        }
        if (filter.hasMore()) {
            xml.attribute("more", "true");
        }
        xml.writeXML(temp.toString());
        xml.closeElement();
    }

    private void parseDayLogs(TicketFilter filter, Date date) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        File[] xlogs = this.directory.listFiles(new DailyLogFileFilter(date, ".xlog"));
        if (xlogs == null) {
            throw new IllegalStateException("Unable to list file in log directory!");
        }
        Arrays.sort(xlogs, FILE_AGE);
        if (xlogs.length == 0) {
            return;
        }
        boolean foundEvents = false;
        for (File xlog : xlogs) {
            boolean keepgoing;
            XLogs.parse(xlog, parser, filter);
            boolean bl = keepgoing = this.singleDayContinueAfterNoEventsFound && !this.multipleDays;
            if (filter.endReached || !keepgoing && foundEvents && !filter.foundEvents) break;
            if (!filter.foundEvents) continue;
            foundEvents = true;
        }
        if (this.multipleDays && !filter.endReached && filter.foundEvents) {
            Calendar tomoz = Calendar.getInstance();
            tomoz.setTime(date);
            tomoz.add(5, 1);
            this.parseDayLogs(filter, tomoz.getTime());
        }
    }

    private static int hourFromTimestamp(long timestamp) {
        return LocalDateTime.ofInstant(new Date(timestamp).toInstant(), ZoneId.systemDefault()).getHour();
    }

    private static class TicketFilter
    extends DefaultHandler {
        private final String startId;
        private final String endId;
        private final @Nullable String groupName;
        private final @Nullable Long groupId;
        private final XMLWriter xml;
        private @Nullable XMLStringWriter temp = null;
        private final int from;
        private final int to;
        private final @Nullable LocalDateTime fromDateTime;
        private final @Nullable LocalDateTime toDateTime;
        private final boolean accessLogs;
        private boolean insideRange;
        private boolean include;
        private boolean endReached;
        private boolean foundEvents;
        private int currentPosition = 0;
        private boolean hasMore = false;
        private final List<String> includeTypes = new ArrayList<String>();
        private final List<String> excludeTypes = new ArrayList<String>();
        private final List<String> methods;
        private final List<String> permissions;

        public TicketFilter(XMLWriter xml, String id, @Nullable Long groupId, @Nullable String groupName, int from, int to, @Nullable LocalDateTime fromT, @Nullable LocalDateTime toT, boolean accessLogs, List<String> permissions, List<String> methods) {
            this.xml = xml;
            if (id.indexOf(46) == -1) {
                this.startId = id;
                this.endId = id;
            } else {
                String[] both = id.split("\\.");
                this.startId = both[0];
                this.endId = both[1];
            }
            this.groupId = groupId;
            this.groupName = groupName;
            this.from = from;
            this.to = to;
            this.fromDateTime = fromT;
            this.toDateTime = toT;
            this.accessLogs = accessLogs;
            this.permissions = permissions;
            this.methods = methods;
        }

        @Override
        public void startDocument() {
            this.endReached = false;
            this.foundEvents = false;
            this.insideRange = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("event".equals(qName)) {
                Object ticket = attributes.getValue("ticket");
                String timestamp = attributes.getValue("timestamp");
                if (this.accessLogs && timestamp != null) {
                    ticket = (String)ticket + "-" + TicketLog.hourFromTimestamp(Long.parseLong(timestamp));
                }
                if (this.startId.equals(ticket)) {
                    this.insideRange = true;
                }
                if (this.startId.equals(this.endId) && !this.startId.equals(ticket)) {
                    this.insideRange = false;
                }
                if (this.endId.equals(ticket) && "complete".equals(attributes.getValue("type"))) {
                    this.endReached = true;
                }
                if (this.insideRange) {
                    String groupIdAtt = attributes.getValue("groupid");
                    boolean correctGroup = this.groupId != null ? String.valueOf(this.groupId).equals(groupIdAtt) || this.groupId == 0L && groupIdAtt == null : this.groupName == null || this.groupName.equals(attributes.getValue("group"));
                    String level = attributes.getValue("level");
                    boolean correctLevel = level == null || (this.includeTypes.isEmpty() || this.includeTypes.contains(level.toLowerCase())) && (this.excludeTypes.isEmpty() || !this.excludeTypes.contains(level.toLowerCase()));
                    boolean correctTime = true;
                    if (this.fromDateTime != null || this.toDateTime != null) {
                        LocalDateTime eventDateTime = LocalDateTime.parse(attributes.getValue("datetime"), DateTimeFormatter.ISO_DATE_TIME);
                        correctTime = !(this.fromDateTime != null && !this.fromDateTime.isBefore(eventDateTime) || this.toDateTime != null && !this.toDateTime.isAfter(eventDateTime));
                    }
                    this.include = correctGroup && correctLevel && correctTime;
                    this.foundEvents = true;
                }
            } else if ("access".equals(localName) || "access".equals(qName)) {
                String permission = attributes.getValue("permission");
                String method = attributes.getValue("method");
                if (!this.permissions.isEmpty() && permission != null && !this.permissions.contains(permission.toLowerCase()) || !this.methods.isEmpty() && method != null && !this.methods.contains(method.toLowerCase())) {
                    this.temp = null;
                }
            }
            if (this.include) {
                if ("event".equals(qName)) {
                    ++this.currentPosition;
                    if (this.validPosition()) {
                        this.temp = new XMLStringWriter(XML.NamespaceAware.No);
                    }
                }
                if (this.temp != null) {
                    this.temp.openElement(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        this.temp.attribute(name, value);
                    }
                } else if (this.currentPosition > this.to) {
                    this.hasMore = true;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.insideRange) {
                return;
            }
            try {
                if (this.temp != null) {
                    this.temp.closeElement();
                }
                if ("event".equals(qName)) {
                    if (this.temp != null) {
                        this.temp.flush();
                        this.xml.writeXML(this.temp.toString());
                        this.temp = null;
                    }
                    this.include = false;
                    if (this.endReached) {
                        this.insideRange = false;
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException("Error while filtering log content", ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.include && this.validPosition() && this.temp != null) {
                this.temp.writeText(ch, start, length);
            }
        }

        private boolean validPosition() {
            return this.currentPosition > this.from && (this.to < 0 || this.currentPosition <= this.to);
        }

        public boolean hasMore() {
            return this.hasMore;
        }
    }
}

