/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.SecurityEvent;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.ISO8601;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class SecurityLogViewer
implements XMLWritable {
    private final File directory;
    private Date date = new Date();
    private int page = 1;
    private @Nullable List<SecurityEvent> events = null;
    private boolean hasMore = false;
    private static final int DEFAULT_PAGE_SIZE = 1000;

    public SecurityLogViewer() {
        this.directory = SecurityLog.getFolder();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Date getDate() {
        return this.date;
    }

    public void build() throws IOException {
        XLoggerAdaptor.ensureRollover();
        List<File> logs = SecurityLog.getFiles(this.date);
        ArrayList<SecurityEvent> events = new ArrayList<SecurityEvent>();
        for (File log : logs) {
            this.load(log, events);
            if (events.size() != 1000) continue;
            break;
        }
        this.events = events;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("events", true);
        xml.attribute("page", this.page);
        xml.attribute("date", ISO8601.CALENDAR_DATE.format(this.date.getTime()));
        if (this.hasMore) {
            xml.attribute("more", "true");
        }
        if (this.events != null) {
            for (SecurityEvent e : this.events) {
                e.toXML(xml);
            }
        } else {
            xml.writeComment("No events loaded yet!");
        }
        xml.closeElement();
    }

    private void load(File log, List<SecurityEvent> events) throws IOException {
        int count = 0;
        int from = (this.page - 1) * 1000;
        int to = this.page * 1000 + 1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(log), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                SecurityEvent e;
                if (++count > from && count < to && (e = SecurityEvent.parse(line)) != null) {
                    events.add(e);
                }
                if (count == to) {
                    this.hasMore = true;
                } else if (count <= to) continue;
                break;
            }
        }
    }
}

