/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.SecurityEvent;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.util.XMLHelpers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SecurityLogSummary
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityLogSummary.class);
    private final LocalDate date;
    private List<TypeSummary> typeSummaries = new ArrayList<TypeSummary>();

    public SecurityLogSummary(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public File getFile() {
        return new File(SecurityLog.getFolder(), "summary-" + String.valueOf(this.date) + ".xml");
    }

    public boolean isAvailable() {
        return this.getFile().exists();
    }

    public static SecurityLogSummary get(LocalDate date) throws IOException {
        SecurityLogSummary summary = new SecurityLogSummary(date);
        if (summary.isAvailable()) {
            summary.load();
        } else {
            summary.build();
            if (!date.equals(LocalDate.now())) {
                summary.save();
            }
        }
        return summary;
    }

    public void build() throws IOException {
        Date localDate = Date.from(this.date.atStartOfDay(ZoneId.systemDefault()).toInstant());
        List<File> logs = SecurityLog.getFiles(localDate);
        EnumMap<SecurityLog.EventType, TypeSummary> counters = new EnumMap<SecurityLog.EventType, TypeSummary>(SecurityLog.EventType.class);
        for (File log : logs) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(log), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    SecurityEvent e = SecurityEvent.parse(line);
                    if (e == null) continue;
                    TypeSummary counter = counters.computeIfAbsent(e.getEventType(), TypeSummary::new);
                    switch (e.getLevel()) {
                        case "INFO": {
                            ++counter.infos;
                            break;
                        }
                        case "WARN": {
                            ++counter.warnings;
                            break;
                        }
                        case "ERROR": {
                            ++counter.errors;
                            break;
                        }
                    }
                }
            }
        }
        this.typeSummaries = new ArrayList(counters.values());
    }

    public synchronized void save() throws IOException {
        File file = this.getFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            XMLWriterImpl xml = new XMLWriterImpl((Writer)writer);
            this.toXML((XMLWriter)xml);
            xml.flush();
        }
    }

    public void load() throws IOException {
        SecurityLogSummary summary = SecurityLogSummary.parse(this.getFile());
        if (summary != null && summary.getDate().equals(this.date)) {
            this.typeSummaries.clear();
            this.typeSummaries.addAll(summary.typeSummaries);
        }
    }

    public static @Nullable SecurityLogSummary parse(File file) throws IOException {
        try {
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            Handler handler = new Handler();
            factory.newSAXParser().parse(file, (DefaultHandler)handler);
            return handler.getLogSummary();
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOGGER.error("Unable to load security log summary", (Throwable)ex);
            return null;
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("summary", true);
        xml.attribute("date", this.date.toString());
        for (TypeSummary summary : this.typeSummaries) {
            summary.toXML(xml);
        }
        xml.closeElement();
    }

    private static class Handler
    extends DefaultHandler {
        private @Nullable SecurityLogSummary summary;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "summary": {
                    this.startSummary(attributes);
                    break;
                }
                case "events": {
                    this.startEvents(attributes);
                    break;
                }
                default: {
                    throw new SAXException("Invalid element: " + qName);
                }
            }
        }

        void startSummary(Attributes attributes) throws SAXException {
            try {
                String date = attributes.getValue("date");
                this.summary = new SecurityLogSummary(LocalDate.parse(date));
            }
            catch (DateTimeException ex) {
                throw new SAXException("Invalid date value");
            }
        }

        void startEvents(Attributes attributes) throws SAXException {
            try {
                SecurityLog.EventType type = SecurityLog.EventType.fromId(attributes.getValue("type"));
                TypeSummary typeSummary = new TypeSummary(type);
                typeSummary.setInfos(Integer.parseInt(attributes.getValue("infos")));
                typeSummary.setWarnings(Integer.parseInt(attributes.getValue("warnings")));
                typeSummary.setErrors(Integer.parseInt(attributes.getValue("errors")));
                if (this.summary != null) {
                    this.summary.typeSummaries.add(typeSummary);
                }
            }
            catch (NullPointerException ex) {
                throw new SAXException("Missing attribute value");
            }
            catch (IllegalArgumentException ex) {
                throw new SAXException("Invalid attribute value");
            }
        }

        public @Nullable SecurityLogSummary getLogSummary() {
            return this.summary;
        }
    }

    private static class TypeSummary
    implements XMLWritable {
        private final SecurityLog.EventType type;
        private int infos;
        private int warnings;
        private int errors;

        public TypeSummary(SecurityLog.EventType type) {
            this.type = type;
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("events", true);
            xml.attribute("type", this.type.id());
            xml.attribute("infos", this.infos);
            xml.attribute("warnings", this.warnings);
            xml.attribute("errors", this.errors);
            xml.closeElement();
        }

        public void setInfos(int infos) {
            this.infos = infos;
        }

        public void setWarnings(int warnings) {
            this.warnings = warnings;
        }

        public void setErrors(int errors) {
            this.errors = errors;
        }
    }
}

