/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;

public final class RateLimitByCodeFilter
extends TurboFilter {
    private final ConcurrentHashMap<String, Long> lastLogTimestamps = new ConcurrentHashMap();
    private long intervalMillis = TimeUnit.HOURS.toMillis(1L);

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] objects, Throwable throwable) {
        if (format.length() < 3) {
            return FilterReply.NEUTRAL;
        }
        if (format.charAt(0) != '[') {
            return FilterReply.NEUTRAL;
        }
        int to = format.indexOf(93, 2);
        if (to < 2) {
            return FilterReply.NEUTRAL;
        }
        String code = format.substring(1, to);
        long now = System.currentTimeMillis();
        Long lastLogTime = this.lastLogTimestamps.get(code);
        if (lastLogTime == null || now - lastLogTime > this.intervalMillis) {
            this.lastLogTimestamps.put(code, now);
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setIntervalSeconds(long seconds) {
        this.intervalMillis = seconds * 1000L;
    }
}

