/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.DailySummary;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@PublicAPI
public abstract class GetDailyLog
implements Generator,
SingleCheck {
    @Override
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws QueryFailedException {
        long groupid = req.getParameter("groupid", -1L);
        if ("true".equals(req.getParameter(StandardParameters.allgroups)) || groupid == -1L && req.getGroup() == null) {
            return new AdminSystemCheck(req.getHttpServletRequest());
        }
        Group gp = req.getGroup();
        if (gp == null && groupid != -1L) {
            gp = DatabaseQuery.getGroupById((Database)req.getDatabase(), (Long)groupid);
        }
        return new EditURICheck(gp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String date = req.getParameter(StandardParameters.date);
        String from = req.getParameter(StandardParameters.from);
        String to = req.getParameter(StandardParameters.to);
        long hour = req.getParameter((Parameter)StandardParameters.time, -1L);
        String permission = req.getParameter((Parameter)StandardParameters.permissions, "").toLowerCase().trim();
        List<String> permissions = permission.isEmpty() ? Collections.emptyList() : Arrays.asList(permission.split(","));
        String method = req.getParameter((Parameter)StandardParameters.methods, "").toLowerCase().trim();
        List<String> methods = method.isEmpty() ? Collections.emptyList() : Arrays.asList(method.split(","));
        XMLWriter xml = res.getXMLWriter();
        DailySummary summary = new DailySummary(this.getLogger());
        if (req.getParameter("by-group", false)) {
            summary.setGroupBy(DailySummary.GroupBy.GROUP);
        } else if (req.getParameter("by-hour", true)) {
            summary.setGroupBy(DailySummary.GroupBy.HOUR);
        }
        summary.setRange(from, to);
        summary.setHour((int)hour);
        summary.setPermissions(permissions);
        summary.setMethods(methods);
        if (this.isAccessLogs()) {
            summary.setAccessLogs();
        }
        try {
            boolean allgroups;
            if (date != null && !"today".equals(date)) {
                summary.setDate(date);
            }
            if (!(allgroups = "true".equals(req.getParameter(StandardParameters.allgroups)))) {
                long groupid;
                long l = groupid = req.getGroup() == null ? -1L : req.getGroup().getId();
                if (groupid == -1L) {
                    groupid = req.getParameter("groupid", -1L);
                }
                if (groupid == -1L) {
                    if (!this.allowNoGroup()) {
                        res.setError(GeneratorStatus.BAD_REQUEST, "No group specified");
                        return;
                    }
                    summary.forServer();
                } else {
                    summary.setGroup(groupid);
                }
            }
            summary.build();
            summary.toXML(xml);
        }
        catch (ParseException ex) {
            req.getLogger(this).error("Could not parse date", (Throwable)ex);
            res.setError(GeneratorStatus.BAD_REQUEST, "Unparseable date '" + date + "'");
        }
        catch (XLogException ex) {
            req.getLogger(this).error("Unable to generate log summary", (Throwable)ex);
        }
        xml.flush();
    }

    public abstract XLoggerAdaptor getLogger();

    public boolean allowNoGroup() {
        return true;
    }

    public boolean isAccessLogs() {
        return false;
    }
}

