/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.XLogLayout;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GeneralEvent
implements XMLWritable {
    private static final int MIN_LINE_SIZE = 38;
    private static final Pattern VALID_LINE = Pattern.compile("(\\S+\\.\\d{3}) \\[(\\S+)\\] (\\S+) \\s?(\\S+) - (.+)");
    private String datetime;
    private String thread;
    private String level;
    private String origin;
    private String message;
    private final StringBuilder throwable = new StringBuilder();

    private GeneralEvent() {
    }

    public void toXML(XMLWriter xml) throws IOException {
        if (XLogLayout.ignoreEvent(this.message)) {
            return;
        }
        xml.openElement("event");
        xml.attribute("datetime", this.datetime);
        xml.attribute("thread", this.thread);
        xml.attribute("level", XLogLayout.adjustLevel(this.level, this.message));
        xml.attribute("logger", this.origin);
        xml.attribute("message", this.message);
        if (this.throwable.length() > 0) {
            xml.element("throwable", this.throwable.toString());
        }
        xml.closeElement();
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public void appendToThrowable(String content) {
        this.throwable.append(content).append('\n');
    }

    public static boolean isProbablyEvent(@Nullable String line) {
        int timePosition = 10;
        int threadPosition = 24;
        return line != null && line.length() > 38 && line.indexOf(84) == 10 && line.indexOf(91) == 24;
    }

    public static @Nullable GeneralEvent parse(@Nullable String line) {
        if (line == null || line.length() < 38) {
            return null;
        }
        Matcher m = VALID_LINE.matcher(line);
        GeneralEvent event = null;
        if (m.matches()) {
            event = new GeneralEvent();
            event.datetime = m.group(1);
            event.thread = m.group(2);
            event.level = m.group(3);
            event.origin = m.group(4);
            event.message = m.group(5);
        }
        return event;
    }
}

