/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.common.http.HttpStatus;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;

public final class AccessEvent
implements XLoggable {
    private @Nullable Permission permission = null;
    private final String session;
    private final String username;
    private @Nullable String ip = null;
    private @Nullable Long groupId = null;
    private @Nullable String group;
    private final @Nullable String path;
    private final @Nullable String query;
    private @Nullable String method;
    private String type;
    private @Nullable String component;
    private @Nullable String docpath = null;
    private @Nullable String doctitle = null;
    private int status = 200;
    private @Nullable Long time = null;
    private @Nullable Long uriId = null;

    private AccessEvent(String session, String user, String path, String query) {
        this.session = session.replace('.', '_');
        this.username = user;
        this.path = path;
        this.query = AccessEvent.removePassword(query);
    }

    public void setIP(String ip) {
        this.ip = ip;
    }

    public void setPermission(Permission p) {
        this.permission = p;
    }

    public void setGroup(@Nullable Group group) {
        if (group == null) {
            return;
        }
        try {
            this.groupId = group.getId();
            this.group = group.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGroup(@Nullable Long id, @Nullable String name) {
        this.groupId = id;
        this.group = name;
    }

    public void setComponent(String type, String component) {
        this.type = type;
        this.component = component;
    }

    public void setStatus(int status) {
        if (this.status == 200) {
            this.status = status;
        }
    }

    public void setDocDetails(@Nullable URI uri) {
        if (uri != null) {
            this.uriId = uri.getId();
            this.docpath = uri.getPath();
            if (uri.getPath() != null) {
                this.doctitle = uri.getDisplayTitle();
            }
        }
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String getTicket() {
        return this.session;
    }

    @Override
    public String getUser() {
        return this.username;
    }

    @Override
    public @Nullable Long getGroupID() {
        return this.groupId;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getTitle() {
        return this.username;
    }

    @Override
    public @Nullable XLoggable.TYPE getType() {
        return null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        out.append(this.username);
        out.append("] ");
        if (this.component != null) {
            out.append(this.type).append(':').append(this.component);
        }
        if (this.group != null) {
            out.append(" (").append(this.group).append(')');
        }
        out.append(" - ");
        if (this.query != null) {
            out.append(" Q=\"").append(this.query).append('\"');
        }
        if (this.docpath != null) {
            out.append(" doc=\"").append(this.docpath).append('\"');
        }
        if (this.doctitle != null) {
            out.append(" title=\"").append(this.doctitle).append('\"');
        }
        if (this.time != null) {
            out.append(" in ").append(this.time).append("ms");
        }
        return out.toString();
    }

    @Override
    public void toXMLLog(Appendable xml) throws IOException {
        xml.append("<access");
        if (this.component != null) {
            xml.append(" type=\"").append(XMLUtils.escapeAttValue((String)this.type)).append('\"');
            xml.append(" component=\"").append(XMLUtils.escapeAttValue((String)this.component)).append('\"');
        }
        if (this.ip != null) {
            xml.append(" ip=\"").append(XMLUtils.escapeAttValue((String)this.ip)).append('\"');
        }
        if (this.path != null) {
            xml.append(" path=\"").append(XMLUtils.escapeAttValue((String)(this.path.startsWith(GlobalSettings.getSitePrefix() + "/publish/session/") ? AccessEvent.removeSessionId(this.path) : this.path))).append('\"');
        }
        if (this.method != null) {
            xml.append(" method=\"").append(XMLUtils.escapeAttValue((String)this.method)).append('\"');
        }
        if (this.permission != null) {
            xml.append(" permission=\"").append(XMLUtils.escapeAttValue((String)this.permission.toString())).append('\"');
        }
        if (this.query != null) {
            String q = this.query;
            if (q.contains("path=%2Fsession%2F")) {
                q = AccessEvent.removeSessionId(URLDecoder.decode(q, StandardCharsets.UTF_8));
            } else if (q.contains("path=/session/")) {
                q = AccessEvent.removeSessionId(q);
            }
            xml.append(" query=\"").append(XMLUtils.escapeAttValue((String)q)).append('\"');
        }
        xml.append(" status=\"").append(HttpStatus.toString((int)this.status)).append('\"');
        if (this.uriId != null) {
            xml.append(" uriid=\"").append(this.uriId.toString()).append('\"');
        }
        if (this.docpath != null) {
            xml.append(" docpath=\"").append(XMLUtils.escapeAttValue((String)this.docpath)).append('\"');
        }
        if (this.doctitle != null) {
            xml.append(" doctitle=\"").append(XMLUtils.escapeAttValue((String)this.doctitle)).append('\"');
        }
        if (this.time != null) {
            xml.append(" time=\"").append(this.time.toString()).append('\"');
        }
        xml.append("/>\r\n");
    }

    private static String removeSessionId(String s) {
        Object res = s;
        int j = s.indexOf("/session/");
        int i = s.indexOf(47, j + 9);
        if (i != -1) {
            res = s.substring(0, j + 9) + "[session ID removed]" + s.substring(i);
        }
        return res;
    }

    public static AccessEvent newInstance(HttpServletRequest request, @Nullable String user) {
        HttpSession session;
        String token = AccessEvent.getToken(request);
        String id = token != null ? token.substring(token.length() - 4) : ((session = request.getSession(false)) != null ? session.getId().substring(session.getId().length() - 4) : "XXXX");
        String ticket = (user != null ? user : "anonymous") + "-" + id;
        Object title = user != null ? user : "anonymous #" + id;
        Integer status = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String requestURI = request.getRequestURI();
        if (status != null) {
            requestURI = (String)request.getAttribute("javax.servlet.error.request_uri");
        }
        AccessEvent info = new AccessEvent(ticket, (String)title, requestURI, request.getQueryString());
        if (status != null) {
            info.setStatus(status);
        }
        info.setIP(SecurityUtils.getRemoteIP(request));
        info.method = request.getMethod();
        return info;
    }

    static @Nullable String removePassword(@Nullable String query) {
        if (query == null) {
            return null;
        }
        return query.replaceAll("password=[^&]+", "password=XXXX");
    }

    static @Nullable String getToken(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (Strings.isEmpty((String)header)) {
            return null;
        }
        String method = HTTP.getAuthScheme((String)header);
        if (!"Bearer".equals(method)) {
            return null;
        }
        String code = HTTP.getBearerToken((String)header);
        if (Strings.isEmpty((String)code)) {
            return null;
        }
        AccessTokenManager manager = AccessTokenManager.singleton();
        AccessToken token = manager.get(code);
        return token == null || token.hasExpired() ? null : token.token();
    }

    public static enum Permission {
        ADMINISTRATOR,
        PROJECT_MANAGER,
        GROUP_MANAGER,
        MEMBER,
        PUBLIC;


        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

