/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.label;

import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class LabelConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelConfigManager.class);

    private LabelConfigManager() {
    }

    public static LabelConfig getLabelConfig(@Nullable Group group) throws IOException, SAXException {
        String owner = group == null ? null : group.getOwnerDirectory();
        return LabelConfigManager.getLabelConfig(owner);
    }

    public static LabelConfig getLabelConfig(@Nullable String owner) throws IOException, SAXException {
        File f = LabelConfigManager.findConfigFile(owner);
        LabelConfig config = null;
        if (f != null && f.exists()) {
            config = LabelConfigManager.load(f);
            config.setScope(LabelConfig.Scope.PROJECT);
        } else {
            config = new LabelConfig("default");
            config.setScope(LabelConfig.Scope.SERVER);
        }
        return config;
    }

    public static @Nullable File findConfigFile(Group group) {
        return LabelConfigManager.findConfigFile(group.getOwnerDirectory());
    }

    public static @Nullable File getConfigFile(Group group) {
        return LabelConfigManager.getConfigFile(group.getOwnerDirectory());
    }

    private static @Nullable File findConfigFile(@Nullable String template) {
        Template kit = LabelConfigManager.toEffectiveTemplate(template);
        return TemplateFiles.findFile((Template)kit, (File)new File(Settings.getContextPath()), (String)"label/label-config.xml");
    }

    private static @Nullable File getConfigFile(@Nullable String template) {
        Template kit = LabelConfigManager.toEffectiveTemplate(template);
        return TemplateFiles.getFile((Template)kit, (File)new File(Settings.getContextPath()), (String)"label/label-config.xml");
    }

    public static synchronized LabelConfig load(File f) throws SAXException, IOException {
        try {
            XMLReader parser = XMLHelpers.safeXMLReader();
            String owner = "Document".equals(f.getParentFile().getName()) ? f.getParentFile().getParentFile().getParentFile().getName() : f.getParentFile().getParentFile().getName();
            Handler handler = new Handler(owner);
            parser.setContentHandler(handler);
            parser.parse(new InputSource(f.toURI().toString()));
            LabelConfig config = handler.getConfig();
            config.setUpdated(f.lastModified());
            return config;
        }
        catch (SAXException ex) {
            LOGGER.warn("Error occurred while parsing label configuration.", (Throwable)ex);
            throw ex;
        }
    }

    public static synchronized void save(File f, LabelConfig config) throws IOException {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No, true);
        config.toXML((XMLWriter)xml, true);
        File dir = f.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create label config folder");
        }
        FileUtils.writeStringToFile((File)f, (String)xml.toString(), (Charset)StandardCharsets.UTF_8);
        try {
            File w = new File(Settings.getContextPath());
            String location = Files.path((File)w, (File)f);
            Template template = TemplateFactory.forLocation((String)location);
            TemplateFiles kr = new TemplateFiles(template, w);
            TemplateHistory history = new TemplateHistory(kr);
            history.backup((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/" + Files.path((File)kr.get((TemplateZone)TemplateFiles.Zone.TEMPLATE), (File)f));
        }
        catch (IOException ex) {
            LOGGER.error("Unable to save a backup copy of the project labels", (Throwable)ex);
        }
    }

    private static Template toEffectiveTemplate(@Nullable String template) {
        String t = template;
        if (t == null) {
            t = GlobalSettings.getGlobalTemplate();
        }
        if (t == null) {
            t = "default";
        }
        return new Template(t);
    }

    private static final class Handler
    extends DefaultHandler {
        private final LabelConfig config;
        private @Nullable LabelType type;

        public Handler(String owner) {
            this.config = new LabelConfig(owner);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ("label".equals(qName) && this.type != null) {
                LabelInfo label = new LabelInfo(atts.getValue("name"), atts.getValue("description"));
                label.setColor(atts.getValue("color"));
                this.config.add(this.type, label);
            } else if ("labels".equals(qName)) {
                String name = atts.getValue("type");
                try {
                    if (name != null) {
                        this.type = LabelType.valueOf(name.toUpperCase().replace('-', '_'));
                    }
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown label type {} in project {}", (Object)name, (Object)this.config.getOwner());
                }
            }
        }

        public LabelConfig getConfig() {
            return this.config;
        }
    }
}

