/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.label;

import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class LabelConfig
implements XMLWritable,
UniversallyPrintable {
    private final Map<LabelType, List<LabelInfo>> config = new LinkedHashMap<LabelType, List<LabelInfo>>();
    private final @Nullable String owner;
    private @Nullable String documenttype;
    private long updated = -1L;
    private Scope scope = Scope.SERVER;

    public LabelConfig(String owner) {
        this.owner = owner;
    }

    public LabelConfig(LabelConfig labels) {
        Objects.requireNonNull(labels, "Cannot copy a null Label Config");
        this.owner = labels.owner;
        this.scope = labels.scope;
        this.documenttype = labels.documenttype;
        this.updated = labels.updated;
        for (LabelType type : labels.config.keySet()) {
            Collection labs = labels.config.get((Object)type);
            this.config.put(type, new ArrayList(labs));
        }
    }

    public void set(LabelType type, Collection<LabelInfo> labels) {
        Objects.requireNonNull(type, "Label type is required");
        List<LabelInfo> current = this.config.get((Object)type);
        if (current == null) {
            current = new ArrayList<LabelInfo>();
            this.config.put(type, current);
        } else {
            current.clear();
        }
        current.addAll(labels);
    }

    public void add(LabelType type, LabelInfo label) {
        this.add(type, label, true);
    }

    public void add(LabelType type, LabelInfo label, boolean overwrite) {
        Objects.requireNonNull(type, "Label type is required");
        List<LabelInfo> labels = this.config.get((Object)type);
        if (labels == null) {
            labels = new ArrayList<LabelInfo>();
            this.config.put(type, labels);
        } else if (overwrite) {
            labels.remove(new LabelInfo(label.name(), null));
        }
        labels.add(label);
    }

    public void addAll(LabelConfig other) {
        Objects.requireNonNull(other, "Label config is required");
        for (LabelType type : other.getTypes()) {
            List<LabelInfo> existing = this.config.get((Object)type);
            if (existing == null) {
                existing = new ArrayList<LabelInfo>();
                this.config.put(type, existing);
            } else {
                for (LabelInfo label : other.getLabelInfos(type)) {
                    existing.remove(new LabelInfo(label.name(), null));
                }
            }
            existing.addAll(other.getLabelInfos(type));
        }
    }

    public void remove(LabelType type, String name) {
        List<LabelInfo> labels = this.config.get((Object)type);
        if (labels != null) {
            labels.remove(new LabelInfo(name, null));
        }
    }

    public Set<LabelType> getTypes() {
        return this.config.keySet();
    }

    public List<LabelInfo> getLabelInfos(LabelType type) {
        return this.config.get((Object)type);
    }

    public @Nullable String getOwner() {
        return this.owner;
    }

    protected Scope getScope() {
        return this.scope;
    }

    protected void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public Date getUpdated() {
        return new Date(this.updated);
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public void toXML(XMLWriter xml) throws IOException {
        this.toXML(xml, false);
    }

    @Override
    public void print(OutputPrinter out) {
        this.print(out, null);
    }

    public void toXML(XMLWriter xml, boolean save) throws IOException {
        xml.openElement("label-config", true);
        if (!save) {
            xml.attribute("scope", this.scope.name().toLowerCase());
            if (this.owner != null) {
                xml.attribute("template", this.owner);
            }
            if (this.documenttype != null) {
                xml.attribute("documenttype", this.documenttype);
            }
            if (this.updated != -1L) {
                xml.attribute("updated", ISO8601.format((long)this.updated, (ISO8601)ISO8601.DATETIME));
            }
        }
        for (Map.Entry<LabelType, List<LabelInfo>> entry : this.config.entrySet()) {
            xml.openElement("labels", true);
            xml.attribute("type", entry.getKey().key());
            for (LabelInfo info : entry.getValue()) {
                info.toXML(xml);
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    public void print(OutputPrinter out, @Nullable Collection<LabelType> types) {
        out.startObject("label-config");
        out.field("scope", this.scope.name().toLowerCase());
        if (this.owner != null) {
            out.field("template", this.owner);
        }
        if (this.documenttype != null) {
            out.field("documenttype", this.documenttype);
        }
        if (this.updated != -1L) {
            out.field("updated", ISO8601.format((long)this.updated, (ISO8601)ISO8601.DATETIME));
        }
        out.startCollection("label-types", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Map.Entry<LabelType, List<LabelInfo>> entry : this.config.entrySet()) {
            if (types != null && !types.contains((Object)entry.getKey())) continue;
            out.startObject("labels");
            out.field("type", entry.getKey().key());
            out.startCollection("labels", OutputPrinter.CollectionOption.JSON_ONLY);
            for (LabelInfo info : entry.getValue()) {
                info.print(out);
            }
            out.endCollection();
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    protected static enum Scope {
        SERVER,
        PROJECT,
        GROUP,
        DOCUMENT;

    }
}

