/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.inspect;

import com.pageseeder.base.inspect.FileInspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeDocumentInspector
implements FileInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDocumentInspector.class);
    private static final String META_ATTRIBUTE_PREFIX = "meta.";
    private static final String PROP_FILE_PATH = "docProps/core.xml";
    private static final Map<String, String> PROPERTIES_NAMESPACES = new HashMap<String, String>();
    private static final Map<String, String> PROPERTIES_TO_LOAD;

    @Override
    public Map<String, String> inspect(File file) throws IOException {
        return this.parsePropertiesFile(file, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> parsePropertiesFile(File file, Charset encoding) {
        try (ZipFile zip = new ZipFile(file, encoding);){
            ZipEntry props = zip.getEntry(PROP_FILE_PATH);
            if (props != null) {
                Map<String, String> map = OfficeDocumentInspector.parse(zip.getInputStream(props));
                return map;
            }
            LOGGER.warn("Invalid Office document {}, PageSeeder cannot find the {} file", (Object)file.getName(), (Object)PROP_FILE_PATH);
            return Collections.emptyMap();
        }
        catch (XMLStreamException ex) {
            LOGGER.warn("Invalid Office document {}, PageSeeder cannot parse the {} file", (Object)file.getName(), (Object)PROP_FILE_PATH);
            return Collections.emptyMap();
        }
        catch (Exception ex) {
            if ("MALFORMED".equals(ex.getMessage()) && StandardCharsets.UTF_8.equals(encoding)) {
                Charset other;
                try {
                    other = Charset.forName("CP437");
                }
                catch (UnsupportedCharsetException ex2) {
                    other = StandardCharsets.ISO_8859_1;
                }
                this.parsePropertiesFile(file, other);
                return Collections.emptyMap();
            }
            LOGGER.warn("Invalid Office document {}, PageSeeder cannot read the file because of a suspicious encoding", (Object)file.getName());
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> parse(InputStream input) throws IOException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        HashMap<String, String> attributes = new HashMap<String, String>();
        try (InputStream inputStream = input;){
            XMLStreamReader xml = factory.createXMLStreamReader(input);
            do {
                String value;
                String element;
                String ns;
                xml.next();
                if (!xml.isStartElement() || (ns = PROPERTIES_TO_LOAD.get(element = xml.getLocalName())) == null || !PROPERTIES_NAMESPACES.get(ns).equals(xml.getNamespaceURI()) || (value = OfficeDocumentInspector.text(xml, element)).isEmpty()) continue;
                attributes.put(META_ATTRIBUTE_PREFIX + ns + "-" + element, value);
            } while (xml.hasNext());
        }
        return attributes;
    }

    private static String text(XMLStreamReader xml, String elementName) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        do {
            String text;
            xml.next();
            if (!xml.isCharacters() || (text = xml.getText()) == null || text.trim().isEmpty()) continue;
            sb.append(xml.getText());
        } while (xml.hasNext() && (!xml.isEndElement() || !elementName.equals(xml.getLocalName())));
        return sb.toString();
    }

    static {
        PROPERTIES_NAMESPACES.put("dc", "http://purl.org/dc/elements/1.1/");
        PROPERTIES_NAMESPACES.put("dcterms", "http://purl.org/dc/terms/");
        PROPERTIES_NAMESPACES.put("cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        PROPERTIES_TO_LOAD = new HashMap<String, String>();
        PROPERTIES_TO_LOAD.put("title", "dc");
        PROPERTIES_TO_LOAD.put("description", "dc");
        PROPERTIES_TO_LOAD.put("creator", "dc");
        PROPERTIES_TO_LOAD.put("subject", "dc");
        PROPERTIES_TO_LOAD.put("created", "dcterms");
        PROPERTIES_TO_LOAD.put("modified", "dcterms");
        PROPERTIES_TO_LOAD.put("keywords", "cp");
        PROPERTIES_TO_LOAD.put("category", "cp");
        PROPERTIES_TO_LOAD.put("revision", "cp");
        PROPERTIES_TO_LOAD.put("version", "cp");
    }
}

