/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.inspect;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.pageseeder.base.inspect.FileInspector;
import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInspector
implements FileInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInspector.class);
    private static final String META_ATTRIBUTE_PREFIX = "meta.";
    private static final Map<String, Integer> EXIF_TAGS = new HashMap<String, Integer>();
    private static final Map<String, Integer> GPS_TAGS;
    private static final Collection<String> GPS_TAGS_TO_CLEAN;

    @Override
    public Map<String, String> inspect(File file) throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Metadata metadata = null;
        try {
            metadata = ImageMetadataReader.readMetadata((File)file);
        }
        catch (ImageProcessingException ex) {
            LOGGER.error("Failed to parse metadata of image {}", (Object)file.getName(), (Object)ex);
        }
        if (metadata != null) {
            TimeZone tz = TimeZone.getTimeZone("GMT" + this.offsetAsString(TimeZone.getDefault().getRawOffset()));
            boolean keywordsDone = false;
            for (Directory dir : metadata.getDirectoriesOfType(IptcDirectory.class)) {
                if (keywordsDone) continue;
                keywordsDone = ImageInspector.addValue(attributes, "iptc-keywords", dir, 537);
            }
            Date gpsDateTimeOriginal = null;
            Date exifDateTime = null;
            Date exifDateTimeOriginal = null;
            HashMap<String, Integer> gpsTags = new HashMap<String, Integer>(GPS_TAGS);
            ArrayList<Object> done = new ArrayList<Object>();
            for (GpsDirectory dir : metadata.getDirectoriesOfType(GpsDirectory.class)) {
                assert (dir != null);
                for (Map.Entry entry : gpsTags.entrySet()) {
                    String prop = (String)entry.getKey();
                    if (!ImageInspector.addValue(attributes, prop, (Directory)dir, (Integer)entry.getValue())) continue;
                    done.add(prop);
                }
                for (String string : done) {
                    gpsTags.remove(string);
                }
                gpsDateTimeOriginal = dir.getGpsDate();
            }
            HashMap<String, Integer> exifTags = new HashMap<String, Integer>(EXIF_TAGS);
            done.clear();
            boolean widthDone = false;
            boolean heightDone = false;
            boolean bl = this.isRotated(metadata);
            for (Directory dir : metadata.getDirectoriesOfType(ExifDirectoryBase.class)) {
                assert (dir != null);
                for (Map.Entry entry : exifTags.entrySet()) {
                    String prop = (String)entry.getKey();
                    if (!ImageInspector.addValue(attributes, prop, dir, (Integer)entry.getValue())) continue;
                    done.add(prop);
                }
                for (String string : done) {
                    exifTags.remove(string);
                }
                if (!widthDone) {
                    widthDone = ImageInspector.addValue(attributes, "exif-image-" + (bl ? "height" : "width"), dir, 40962);
                }
                if (!widthDone) {
                    widthDone = ImageInspector.addValue(attributes, "exif-image-" + (bl ? "height" : "width"), dir, 256);
                }
                if (!heightDone) {
                    heightDone = ImageInspector.addValue(attributes, "exif-image-" + (bl ? "width" : "height"), dir, 40963);
                }
                if (!heightDone) {
                    heightDone = ImageInspector.addValue(attributes, "exif-image-" + (bl ? "width" : "height"), dir, 257);
                }
                if (exifDateTime == null) {
                    exifDateTime = dir.getDate(306, tz);
                }
                if (exifDateTimeOriginal != null) continue;
                exifDateTimeOriginal = dir.getDate(36867, tz);
            }
            Date originalDateTime = null;
            Date dateTime = null;
            if (gpsDateTimeOriginal != null) {
                originalDateTime = gpsDateTimeOriginal;
                if (exifDateTime != null && exifDateTimeOriginal != null && exifDateTime.getTime() == exifDateTimeOriginal.getTime()) {
                    dateTime = gpsDateTimeOriginal;
                }
            } else if (exifDateTimeOriginal != null) {
                originalDateTime = exifDateTimeOriginal;
            }
            if (dateTime == null) {
                dateTime = exifDateTime;
            }
            if (originalDateTime != null) {
                attributes.put("meta.exif-date-time-original", ISO8601.DATETIME.format(originalDateTime.getTime()));
            }
            if (dateTime != null) {
                attributes.put("meta.exif-date-time", ISO8601.DATETIME.format(dateTime.getTime()));
            }
        }
        return attributes;
    }

    private static boolean addValue(Map<String, String> attributes, String name, @Nullable Directory dir, int tag) {
        String val;
        if (dir != null && (val = dir.getDescription(tag)) != null) {
            if ("exif-f-number".equals(name)) {
                val = val.replaceFirst("^f/", "");
            }
            if (GPS_TAGS_TO_CLEAN.contains(name)) {
                val = val.replaceFirst("^-", "");
            }
            val = val.replaceFirst("( dots per inch$)|( pixels$)|( mm$)|( metres$)", "");
            attributes.put(META_ATTRIBUTE_PREFIX + name, val);
            return true;
        }
        return false;
    }

    private String offsetAsString(int offsetMillis) {
        double offset = (double)offsetMillis / 3600000.0;
        double offsetAbs = Math.abs(offset);
        int minutes = (int)(offsetAbs - (double)((int)offsetAbs)) * 100;
        return (offset != offsetAbs ? "-" : "+") + (offsetAbs < 10.0 ? "0" : "") + (int)offsetAbs + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    private boolean isRotated(Metadata metadata) {
        try {
            for (Directory dir : metadata.getDirectoriesOfType(ExifDirectoryBase.class)) {
                Integer orientation = dir.getInteger(274);
                if (orientation == null || orientation <= 4) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.warn("Orientation error", (Throwable)ex);
            return false;
        }
    }

    static {
        EXIF_TAGS.put("exif-artist", 315);
        EXIF_TAGS.put("exif-color-space", 40961);
        EXIF_TAGS.put("exif-copyright", 33432);
        EXIF_TAGS.put("exif-exposure-time", 33434);
        EXIF_TAGS.put("exif-f-number", 33437);
        EXIF_TAGS.put("exif-focal-length", 37386);
        EXIF_TAGS.put("exif-image-description", 270);
        EXIF_TAGS.put("exif-iso-speed-ratings", 34855);
        EXIF_TAGS.put("exif-make", 271);
        EXIF_TAGS.put("exif-model", 272);
        EXIF_TAGS.put("exif-user-comment", 37510);
        EXIF_TAGS.put("exif-x-resolution", 282);
        EXIF_TAGS.put("exif-y-resolution", 283);
        GPS_TAGS = new HashMap<String, Integer>();
        GPS_TAGS.put("exif-gps-altitude", 6);
        GPS_TAGS.put("exif-gps-altitude-ref", 5);
        GPS_TAGS.put("exif-gps-latitude", 2);
        GPS_TAGS.put("exif-gps-latitude-ref", 1);
        GPS_TAGS.put("exif-gps-longitude", 4);
        GPS_TAGS.put("exif-gps-longitude-ref", 3);
        GPS_TAGS.put("exif-gps-dest-latitude", 20);
        GPS_TAGS.put("exif-gps-dest-latitude-ref", 19);
        GPS_TAGS.put("exif-gps-dest-longitude", 22);
        GPS_TAGS.put("exif-gps-dest-longitude-ref", 21);
        GPS_TAGS_TO_CLEAN = new ArrayList<String>();
        GPS_TAGS_TO_CLEAN.add("exif-gps-latitude");
        GPS_TAGS_TO_CLEAN.add("exif-gps-longitude");
        GPS_TAGS_TO_CLEAN.add("exif-gps-dest-latitude");
        GPS_TAGS_TO_CLEAN.add("exif-gps-dest-longitude");
    }
}

