/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratorRequestBase
implements GeneratorRequest {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private @Nullable String etag = null;
    protected @Nullable Database db = null;
    private @Nullable Transaction tr = null;
    @Nullable Group group = null;
    private @Nullable Member member = null;
    private @Nullable URI uri = null;
    private @Nullable String hostname = null;

    protected GeneratorRequestBase() {
    }

    @Override
    public final @Nullable String getETag() {
        return this.etag;
    }

    @Override
    public final Database getDatabase() {
        assert (this.db != null);
        return this.db;
    }

    @Override
    public final Transaction getTransaction() {
        assert (this.tr != null);
        return this.tr;
    }

    @Override
    public final @Nullable Group getGroup() {
        return this.group;
    }

    @Override
    public final String getHostName() {
        assert (this.hostname != null);
        return this.hostname;
    }

    @Override
    public final @Nullable Member getMember() {
        return this.member;
    }

    @Override
    public @Nullable Member getAuthenticatedMember() {
        return null;
    }

    @Override
    public final @Nullable URI getURI() {
        return this.uri;
    }

    @Override
    public final @Nullable String getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public final long getParameter(String name, long def) {
        String v = this.parameters.get(name);
        if (v == null || v.isEmpty()) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    @Override
    public final String getParameter(String name, String def) {
        String v = this.parameters.get(name);
        return v == null || v.isEmpty() ? def : v;
    }

    @Override
    public final boolean getParameter(String name, boolean def) {
        String v = this.parameters.get(name);
        if (v == null || v.isEmpty()) {
            return def;
        }
        if (def) {
            return !"false".equals(v);
        }
        return "true".equals(v);
    }

    @Override
    public final @Nullable String getParameter(Parameter parameter) {
        return this.parameters.get(parameter.getName());
    }

    @Override
    public @Nullable String getNonEmptyParameter(Parameter parameter) {
        String v = this.parameters.get(parameter.getName());
        return v == null || v.isEmpty() ? null : v;
    }

    @Override
    public final long getParameter(Parameter parameter, long def) {
        return this.getParameter(parameter.getName(), def);
    }

    @Override
    public final String getParameter(Parameter parameter, String def) {
        return this.getParameter(parameter.getName(), def);
    }

    @Override
    public final boolean getParameter(Parameter parameter, boolean def) {
        return this.getParameter(parameter.getName(), def);
    }

    @Override
    public final Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public final Logger getLogger(@Nullable Object o) {
        return LoggerFactory.getLogger(o == null ? Generator.class : o.getClass());
    }

    public final void putParameters(Map<String, String> p) {
        this.parameters.putAll(p);
    }

    public final void setDatabase(Database db) {
        this.db = db;
    }

    public final void setTransaction(Transaction tr) {
        this.tr = tr;
    }

    public final void setEtag(String etag) {
        this.etag = etag;
    }

    public final void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public final void setURI(@Nullable URI uri) {
        this.uri = uri;
    }

    public final void setMember(@Nullable Member member) {
        this.member = member;
    }

    public final void setGroup(@Nullable Group group) {
        this.group = group;
    }
}

