/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.Initializable;
import com.pageseeder.base.generator.Unavailable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorFactory.class);
    private final Map<String, Generator> generators = new Hashtable<String, Generator>();

    public Generator getInstance(String classname) {
        Objects.requireNonNull(classname, "No class name for generator.");
        Generator generator = this.generators.get(classname);
        if (generator == null) {
            generator = GeneratorFactory.make(classname);
            this.generators.put(classname, generator);
        }
        return generator;
    }

    public void clear() {
        this.generators.clear();
    }

    private static Generator make(String classname) {
        Generator generator = null;
        try {
            generator = (Generator)Class.forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.warn("(!) Failed to instantiate {}, flagged as unavailable", (Object)classname, (Object)ex);
            return new Unavailable(FrameworkErrorID.GENERATOR_INSTANTIATION_ERROR);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn("(!) Failed to load {}, flagged as unavailable", (Object)classname, (Object)ex);
            return new Unavailable(FrameworkErrorID.GENERATOR_NOT_FOUND);
        }
        if (generator instanceof Initializable) {
            try {
                ((Initializable)((Object)generator)).init();
            }
            catch (Exception ex) {
                LOGGER.error("(!) Failed to initialize {}, flagged as unavailable", (Object)classname, (Object)ex);
                return new Unavailable(FrameworkErrorID.GENERATOR_INITIALIZATION_ERROR);
            }
        }
        return generator;
    }
}

