/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.ErrorID;

public enum FrameworkErrorID implements ErrorID
{
    UNSPECIFIED(0, "Unspecified error"),
    FAILED_PERMISSION_CHECK(257, "Failed the permission check"),
    SERVICE_NOT_FOUND(258, "Unable to find requested service"),
    BAD_HTTP_METHOD_OVERRIDE(259, "Unable to override HTTP method"),
    BAD_CONTENT_TYPE(260, "Unable to provide acceptable content type."),
    DOMAIN_RESTRICTED_ACCESS(261, "Can only be accessed by using webSiteAddress domain."),
    MEMBER_NOT_FOUND(262, "Unable to find matching member."),
    GROUP_NOT_FOUND(263, "Unable to find matching group."),
    URI_NOT_FOUND(264, "Unable to find matching uri."),
    OBJECT_NOT_FOUND(265, "Unable to find matching object."),
    UNSUPPORTED_OUTPUT_TYPE(266, "Unable to generate this output type."),
    GENERATOR_NOT_FOUND(1536, "Unable to find generator class"),
    GENERATOR_INSTANTIATION_ERROR(1537, "Unable to instantiate the generator"),
    GENERATOR_INITIALIZATION_ERROR(1538, "Unable to initialise the generator, init() method failed"),
    NO_DATABASE_CONNECTION(1539, "Unable to connect to the database"),
    EXCEPTION_CAUGHT(2048, "Runtime exception thrown by generator"),
    GENERATOR_EXCEPTION(2049, "Exception thrown by generator on purpose"),
    DATABASE_ERROR(2050, "Database exception thrown by generator");

    private final int id;
    private final String message;

    private FrameworkErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        if (id > 65535) {
            throw new IndexOutOfBoundsException("Error ID cannot be greater than 0xffff");
        }
        this.id = id;
        this.message = message;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String message() {
        return this.message;
    }
}

