/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.common.util.Strings;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PropertiesFragmentHandler
extends DefaultHandler {
    private static final String METADATA_ELEMENT = "metadata";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private XMLWriter xml = null;
    private CharArrayWriter xmlbuffer = new CharArrayWriter();
    private String beforexml = "";
    private String fragElement;
    private String fragType;
    private final List<String> propertyNames = new ArrayList<String>();
    private final Map<String, String> propertyValues = new HashMap<String, String>();

    public PropertiesFragmentHandler() {
        this.xml = new XMLWriterNSImpl((Writer)this.xmlbuffer);
    }

    public String getFragmentElement() {
        return this.fragElement;
    }

    public String getFragmentType() {
        return this.fragType;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Map<String, String> getPropertyValues() {
        return this.propertyValues;
    }

    public String getBeforeXML() {
        return this.beforexml;
    }

    public String getAfterXML() {
        return this.xmlbuffer.toString();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.xml.setPrefixMapping(uri, prefix);
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        boolean isFragment;
        boolean bl = isFragment = PSMLContentUtils.isFragmentElement(lName) || PROPERTIES_ELEMENT.equals(lName);
        if (isFragment) {
            this.fragElement = lName;
            this.fragType = atts.getValue(TYPE_ATTRIBUTE);
        } else if (PROPERTY_ELEMENT.equals(lName) && atts.getValue(NAME_ATTRIBUTE) != null) {
            String name = atts.getValue(NAME_ATTRIBUTE);
            this.propertyNames.add(name);
            String datatype = atts.getValue("datatype");
            if ((datatype == null || "text".equals(datatype) || "date".equals(datatype) || "datetime".equals(datatype)) && (atts.getValue("count") == null || "1".equals(atts.getValue("count"))) && atts.getValue("multiple") == null) {
                this.propertyValues.put(name, atts.getValue("value") == null ? "" : atts.getValue("value"));
            }
        } else if (METADATA_ELEMENT.equals(lName)) {
            this.fragElement = PROPERTIES_ELEMENT;
        }
        try {
            this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, lName, false);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.xml.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + lName, ex);
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        try {
            if (this.beforexml.isEmpty() && METADATA_ELEMENT.equals(lName)) {
                this.xml.openElement(PROPERTIES_ELEMENT);
                this.xml.writeText(' ');
                this.beforexml = this.xmlbuffer.toString();
                this.xmlbuffer.reset();
                this.xml.closeElement();
            } else if (PSMLContentUtils.isFragmentElement(lName) || PROPERTIES_ELEMENT.equals(lName)) {
                this.xml.writeText(' ');
                this.beforexml = this.xmlbuffer.toString();
                this.xmlbuffer.reset();
            }
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + lName, ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xml.writeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }
}

